#include <stdbool.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

double R12x12[12][12];
double S12x12[12][12];
double ONE12x12[12][12];
double TWO12x12[12][12];
double I12x12[12][12];
double LT12x12[12][12];
double UT12x12[12][12];
double LT12x12bad[12][12];

double ONES1x5[1][5] = {
        {1,1,1,1,1}
};
double ONES5x1[5][1] = {
        {1},
        {1},
        {1},
        {1},
        {1}
};

double A5x5[5][5] = {
        {1,2,3,4,5},
        {2,3,4,5,6},
        {3,4,5,6,7},
        {4,5,6,7,8},
        {5,6,7,8,9}
};
double B5x5[5][5] = {
        {8,5,3,4,5},
        {2,3,8,5,16},
        {2,4,8,6,7},
        {4,5,19,7,8},
        {5,4,7,8,9}
};
double UT5x5[5][5] = {
        {1,2,3,4,5},
        {0,3,4,5,6},
        {0,0,5,6,7},
        {0,0,0,7,8},
        {0,0,0,0,9}
};
double LT5x5[5][5] = {
        {1,0,0,0,0},
        {2,3,0,0,0},
        {3,4,5,0,0},
        {4,5,6,7,0},
        {5,6,7,8,9}
};
double I5x5[5][5] = {
        {1,0,0,0,0},
        {0,1,0,0,0},
        {0,0,1,0,0},
        {0,0,0,1,0},
        {0,0,0,0,1}
};
double TWO5x5[5][5] = {
        {2,0,0,0,0},
        {0,2,0,0,0},
        {0,0,2,0,0},
        {0,0,0,2,0},
        {0,0,0,0,2}
};
double I3x3[3][3] = {
        {1,0,0},
        {0,1,0},
        {0,0,1}
};
double TWO3x3[3][3] = {
        {2,0,0},
        {0,2,0},
        {0,0,2}
};
double Z3x3[3][3] = {
        {0,0,0},
        {0,0,0},
        {0,0,0}
};
double Z5x5[5][5] = {
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0}
};
double SFC5x5[5][5] = {
        {1,1,1,1,1},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0}
};
double FR5x5[5][5] = {
        {1,0,0,0,0},
        {1,0,0,0,0},
        {1,0,0,0,0},
        {1,0,0,0,0},
        {1,0,0,0,0}
};
double C5x5[5][5] = {
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0},
        {0,0,0,0,0}
};
double A3x3[3][3] = {
        {1,2,3},
        {2,3,4},
        {3,4,5}
};
double UT3x3[3][3] = {
        {1,2,3},
        {0,3,4},
        {0,0,5}
};
double LT3x3[3][3] = {
        {1,0,0},
        {2,3,0},
        {3,4,5}
};
double LT3x3bad1[3][3] = {
        {1,1,0},
        {2,3,0},
        {3,4,5}
};
double LT3x3bad2[3][3] = {
        {1,0,0},
        {2,3,1},
        {3,4,5}
};
double LT3x3bad3[3][3] = {
        {1,0,1},
        {2,3,0},
        {3,4,5}
};
double LT3x3bad4[3][3] = {
        {1,1,0},
        {2,3,1},
        {3,4,5}
};
double LT3x4[3][4] = {
        {1,0,0,0},
        {2,3,0,0},
        {3,4,5,0}
};
double LT4x3[4][3] = {
        {1,0,0},
        {2,3,0},
        {3,4,5},
        {4,5,6}
};
double LT3x4b[3][4] = {
        { 1, 0,4,0},
        {-2, 3,0,8},
        {-3,-4,5,0}
};
double ONEST3x4[3][4] = {
        {1,1,1,1},
        {1,1,1,1},
        {1,1,1,1}
};
double ONEST4x3[4][3] = {
        {1,1,1},
        {1,1,1},
        {1,1,1},
        {1,1,1}
};

double tyxaios(double a) {
    double R;
    do {
        R = (2*a*rand())/RAND_MAX-a;
    } while (R==0.0);
    return R;
}
int printMatrix(int M, int N, double A[M][N]) {
    printf("\n");
    if (M<1 || N <1) {
        printf("%d x %d",M,N);
        return '!';
    }
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            double L = A[r][c];
            printf("%5.2lf ", L);
        }
        if (r<M-1) printf("\n");
    }
    return ' ';
}
void initRandomArrays() {
    srand(time(0));
    for (int i = 0; i < 12; ++i) {
        for (int j = 0; j < 12; ++j) {
            R12x12[i][j] = tyxaios(10);
            S12x12[i][j] = tyxaios(10);
            ONE12x12[i][j] = 1.0;
            TWO12x12[i][j] = 0.0;
            I12x12[i][j] = 0.0;
            if (i>j) {
                UT12x12[i][j] = 0;
                LT12x12[i][j] = tyxaios(10);
                LT12x12bad[i][j] = tyxaios(10);
            } else if (i<j) {
                UT12x12[i][j] = tyxaios(10);
                LT12x12[i][j] = 0;
                LT12x12bad[i][j] = 0;
            } else {
                UT12x12[i][j] = tyxaios(10);
                LT12x12[i][j] = tyxaios(10);
                LT12x12bad[i][j] = tyxaios(10);
                TWO12x12[i][j] = 2.0;
                I12x12[i][j] = 1.0;
            }
        }
    }
    for (int i = 0; i < 3; ++i) {
        int R;
        do {
            R = floor(tyxaios(12/2)+12/2);
        } while (R>10);
        LT12x12bad[R][R+1] = tyxaios(10);
    }
}
double sumOf2D(int M, int N, double X[M][N]) {
    double S=0.0;
    for (int i = 0; i < M; ++i) {
        for (int j = 0; j < N; ++j) {
            S += X[i][j];
        }
    }
    return S;
}
bool negate(int M, int N, double A[M][N], double NEG[M][N]) {
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            NEG[r][c] = -A[r][c];
        }
    }
    return true;
}
bool checkZero(int M, int N, double A[M][N]) {
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            if (fabs(A[r][c]) > 1e-4) {
                return false;
            }
        }
    }
    return true;
}
bool checkPlus1(int M, int N, double A[M][N], double P1[M][N]) {
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            double aa = A[r][c];
            double pp = P1[r][c];
            if (fabs(pp-1-aa) > 1e-5) {
                return false;
            }
        }
    }
    return true;
}
bool checkDouble(int M, int N, double A[M][N], double D[M][N]) {
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            if (2*A[r][c] != D[r][c]) {
                return false;
            }
        }
    }
    return true;
}
bool checkEqual(int M, int N, double A[M][N], double D[M][N]) {
    for (int r = 0; r < M; ++r) {
        for (int c = 0; c < N; ++c) {
            // pvp - ayto epitrepei thn kalypsh arithmitikwn sfalmatwn
            double famax = (fabs(A[r][c]) > fabs(D[r][c]) ) ? fabs(A[r][c]) : fabs(D[r][c]);
            if (fabs(A[r][c] - D[r][c]) > famax/1e10) {
                return false;
            }
        }
    }
    return true;
}
bool maimu(int M, int N, int K, double A[M][N], double B[N][K] , double P[M][K]) {
    if (M>0 && N>0 && K>0) {
        double S;
        for (int c = 0 ; S=0.0, c < M*K; ++c) { for (int i = 0; i < N; ++i) S += A[c/K][i] * B[i][c%K]; P[c/K][c%K]=S;}
        return true;
    } else {
        return false;
    }
}
bool isLTriangular(int R, int C, double A[R][C]);
bool add(int R, int C, double A[R][C], double B[R][C] , double sum[R][C]);
bool mul(int M, int N, int K, double A[M][N], double B[N][K] , double P[M][K]);

PICOTEST_SUITE(mainSuite, LTRIANGLE_TESTS, SUM_TESTS, MUL_TESTS, COMBO_TESTS)
PICOTEST_CASE(LTRIANGLE_TESTS) {
    initRandomArrays();
    PICOTEST_VERIFY(!isLTriangular(0,3,LT3x3), smMsg('A', "test_a-2-1-a", "Failed to verify that the size is not correct%c", printMatrix(0,3,A3x3)));
    PICOTEST_VERIFY(!isLTriangular(3,0,LT3x3), smMsg('A', "test_a-2-1-a", "Failed to verify that the size is not correct%c", printMatrix(3,0,A3x3)));
    PICOTEST_VERIFY(!isLTriangular(0,0,LT3x3), smMsg('A', "test_a-2-1-a", "Failed to verify that the size is not correct%c", printMatrix(0,0,A3x3)));
    PICOTEST_VERIFY(!isLTriangular(-1,3,LT3x3), smMsg('A', "test_a-2-1-b", "Failed to verify that the size is not correct%c", printMatrix(-1,3,A3x3)));
    PICOTEST_VERIFY(!isLTriangular(3,-1,LT3x3), smMsg('A', "test_a-2-1-b", "Failed to verify that the size is not correct%c", printMatrix(3,-1,A3x3)));
    PICOTEST_VERIFY(!isLTriangular(-1,-1,LT3x3), smMsg('A', "test_a-2-1-b", "Failed to verify that the size is not correct%c", printMatrix(-1,-1,A3x3)));

    PICOTEST_VERIFY(!isLTriangular(3,3,A3x3), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,A3x3)));
    PICOTEST_VERIFY(isLTriangular(3,3,LT3x3), smMsg('A', "test_a-2-1-d", "Failed to verify if array above IS Lower Triangular%c", printMatrix(3,3,LT3x3)));
    PICOTEST_VERIFY(!isLTriangular(3,3,UT3x3), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,UT3x3)));
    PICOTEST_VERIFY(!isLTriangular(3,3,LT3x3bad1), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,LT3x3bad1)));
    PICOTEST_VERIFY(!isLTriangular(3,3,LT3x3bad2), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,LT3x3bad2)));
    PICOTEST_VERIFY(!isLTriangular(3,3,LT3x3bad3), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,LT3x3bad3)));
    PICOTEST_VERIFY(!isLTriangular(3,3,LT3x3bad4), smMsg('A', "test_a-2-1-c", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,3,LT3x3bad4)));

    PICOTEST_VERIFY(!isLTriangular(3,4,LT3x4), smMsg('A', "test_a-2-1-e", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(3,4,LT3x4)));
    PICOTEST_VERIFY(!isLTriangular(4,3,LT4x3), smMsg('A', "test_a-2-1-e", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(4,3,LT4x3)));

    PICOTEST_VERIFY(isLTriangular(5,5,LT5x5), smMsg('A', "test_a-2-1-f", "Failed to verify if array above IS Lower Triangular%c", printMatrix(5,5,LT5x5)));
    PICOTEST_VERIFY(!isLTriangular(5,5,UT5x5), smMsg('A', "test_a-2-1-f", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(5,5,UT5x5)));
    PICOTEST_VERIFY(!isLTriangular(5,5,A5x5), smMsg('A', "test_a-2-1-f", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(5,5,A5x5)));

    PICOTEST_VERIFY(isLTriangular(12,12,LT12x12), smMsg('A', "test_a-2-1-g", "Failed to verify if array above IS Lower Triangular%c", printMatrix(12,12,LT12x12)));
    PICOTEST_VERIFY(!isLTriangular(12,12,UT12x12), smMsg('A', "test_a-2-1-g", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(12,12,UT12x12)));
    PICOTEST_VERIFY(!isLTriangular(12,12,R12x12), smMsg('A', "test_a-2-1-g", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(12,12,R12x12)));
    PICOTEST_VERIFY(!isLTriangular(12,12,LT12x12bad), smMsg('A', "test_a-2-1-g", "Failed to verify that array above is NOT Lower Triangular%c", printMatrix(12,12,LT12x12bad)));
}
PICOTEST_CASE(SUM_TESTS) {
    double RES3x3[3][3];
    double RES3x4[3][4];
    double RES4x3[4][3];
    double RES5x5[5][5];
    double RES12x12[12][12];
    double NEGA3x3[3][3];
    double NEGA5x5[5][5];
    double NEGR12x12[12][12];

    negate(3,3,A3x3,NEGA3x3);
    negate(5,5,A5x5,NEGA5x5);
    negate(12,12,R12x12,NEGR12x12);

    initRandomArrays();

    PICOTEST_VERIFY(!add(0,3,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-a", "Failed to verify that the addition is not correct%c", printMatrix(0,3,A3x3)));
    PICOTEST_VERIFY(!add(3,0,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-a", "Failed to verify that the addition is not correct%c", printMatrix(3,0,A3x3)));
    PICOTEST_VERIFY(!add(0,0,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-a", "Failed to verify that the addition is not correct%c", printMatrix(0,0,A3x3)));
    PICOTEST_VERIFY(!add(-1,3,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-b", "Failed to verify that the addition is not correct%c", printMatrix(-1,3,A3x3)));
    PICOTEST_VERIFY(!add(3,-1,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-b", "Failed to verify that the addition is not correct%c", printMatrix(3,-1,A3x3)));
    PICOTEST_VERIFY(!add(-1,-1,A3x3,I3x3,RES3x3), smMsg('A', "test_a-2-2-b", "Failed to verify that the addition is not correct%c", printMatrix(-1,-1,A3x3)));

    PICOTEST_VERIFY(add(3,3,A3x3,A3x3,RES3x3) && checkDouble(3,3,A3x3, RES3x3), smMsg('A', "test_a-2-2-c", "Failed to verify the sum %c%c", printMatrix(3,3,A3x3), printMatrix(3,3,RES3x3)));
    PICOTEST_VERIFY(add(5,5,A5x5,A5x5,RES5x5) && checkDouble(5,5,A5x5, RES5x5), smMsg('A', "test_a-2-2-c", "Failed to verify the sum %c%c", printMatrix(5,5,A5x5), printMatrix(5,5,RES5x5)));
    PICOTEST_VERIFY(add(12,12,R12x12,R12x12,RES12x12) && checkDouble(12,12,R12x12,RES12x12), smMsg('A', "test_a-2-2-c", "Failed to verify the sum %c%c", printMatrix(12,12,R12x12), printMatrix(12,12,RES12x12)));
    PICOTEST_VERIFY(add(3,3,A3x3,NEGA3x3,RES3x3) && checkZero(3,3, RES3x3),
            smMsg('A', "test_a-2-2-d",
            "Failed to verify the sum %c%c",
            printMatrix(3,3,A3x3), printMatrix(3,3,RES3x3)));
    PICOTEST_VERIFY(add(5,5,A5x5,NEGA5x5,RES5x5) && checkZero(5,5, RES5x5),
            smMsg('A', "test_a-2-2-d",
            "Failed to verify the sum %c%c",
            printMatrix(5,5,A5x5), printMatrix(5,5,RES5x5)));
    PICOTEST_VERIFY(add(12,12,R12x12,NEGR12x12,RES12x12) && checkZero(12,12, RES12x12),
            smMsg('A', "test_a-2-2-d",
            "Failed to verify the sum %c%c",
            printMatrix(12,12,R12x12), printMatrix(12,12,RES12x12)));
    PICOTEST_VERIFY(add(12,12,R12x12,ONE12x12,RES12x12) && checkPlus1(12,12, R12x12, RES12x12),
            smMsg('A', "test_a-2-2-e",
            "Failed to verify the sum %c%c%c",
            printMatrix(12,12,R12x12), printMatrix(12,12,ONE12x12), printMatrix(12,12,RES12x12)));

    PICOTEST_VERIFY(add(3,4,LT3x4,ONEST3x4,RES3x4) && checkPlus1(3,4, LT3x4, RES3x4), smMsg('A', "test_a-2-2-f", "Failed to verify the sum %c%c", printMatrix(3,4,LT3x4), printMatrix(3,4,RES3x4)));
    PICOTEST_VERIFY(add(4,3,LT4x3,ONEST4x3,RES4x3) && checkPlus1(4,3, LT4x3, RES4x3), smMsg('A', "test_a-2-2-f", "Failed to verify the sum %c%c", printMatrix(4,3,LT4x3), printMatrix(4,3,RES4x3)));
}
PICOTEST_CASE(MUL_TESTS) {
    double RES1x1[1][1];
    double RES3x3[3][3];
    double RES3x4[3][4];
    double RES4x3[4][3];
    double RES5x5[5][5];
    double RESB5x5[5][5];
    double RES1x5[1][5];
    double RES5x1[5][1];
    double RES12x12[12][12];
    double RESB12x12[12][12];

    initRandomArrays();

    PICOTEST_VERIFY(!mul(0,12,12,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-a", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(12,0,12,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-a", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(12,12,0,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-a", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(-1,12,12,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-b", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(12,-1,12,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-b", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(12,12,-1,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-b", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(-1,-1,12,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-c", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(12,-1,-1,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-c", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(-1,12,-1,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-c", "Failed to verify that the multiplication is not correct"));
    PICOTEST_VERIFY(!mul(-1,-1,-1,R12x12,R12x12,RES12x12), smMsg('A', "test_a-2-3-c", "Failed to verify that the multiplication is not correct"));

    PICOTEST_VERIFY(mul(12,12,12,R12x12,TWO12x12,RES12x12) && checkDouble(12,12, R12x12, RES12x12),
            smMsg('A', "test_a-2-3-d",
            "Failed to verify that the multiplication is correct%c%c%c",
            printMatrix(12,12,R12x12), printMatrix(12,12,TWO12x12), printMatrix(12,12,RES12x12)));
    PICOTEST_VERIFY(mul(12,12,12,R12x12,I12x12,RES12x12) && checkEqual(12,12, R12x12, RES12x12),
            smMsg('A', "test_a-2-3-e",
            "Failed to verify that the multiplication is correct%c%c%c",
            printMatrix(12,12,R12x12), printMatrix(12,12,I12x12), printMatrix(12,12,RES12x12)));

    PICOTEST_VERIFY(mul(1,5,5,ONES1x5,A5x5,RES1x5) && mul(1,5,1,RES1x5,ONES5x1,RES1x1) && sumOf2D(5,5,A5x5)==RES1x1[0][0],
            smMsg('A', "test_a-2-3-f",
            "Failed to verify that the multiplication is correct %c%c%c = %d",
            printMatrix(1,5,ONES1x5), printMatrix(5,5,A5x5), printMatrix(5,1,ONES5x1), RES1x1[0][0]));
    PICOTEST_VERIFY(mul(12,12,12,R12x12,S12x12,RES12x12) &&
                    maimu(12,12,12,R12x12,S12x12,RESB12x12) &&
                    checkEqual(12,12,RES12x12,RESB12x12),
            smMsg('A', "test_a-2-3-g", "Failed to verify that the multiplication is correct %c%c%c%c",
            printMatrix(12,12,R12x12), printMatrix(12,12,S12x12), printMatrix(12,12,RES12x12), printMatrix(12,12,RESB12x12)));
}
PICOTEST_CASE(COMBO_TESTS) {
    double RES5x5[5][5];
    double RESB5x5[5][5];
    double RESC5x5[5][5];
    PICOTEST_VERIFY(mul(5,5,5,A5x5,B5x5,RES5x5) && maimu(5,5,5,A5x5,B5x5,RESB5x5) &&
                    negate(5,5,RESB5x5,RESB5x5) && add(5,5,RES5x5,RESB5x5,RESC5x5) && checkZero(5,5,RESC5x5),
            smMsg('A', "test_a-2-4-a",
            "Failed to verify the expression A*B - B*A <> 0 %c%c%c",
            printMatrix(5,5,A5x5), printMatrix(5,5,B5x5), printMatrix(5,5,RESC5x5)));
}
