#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

bool hasSuffix(char text[], char suffix[], bool caseSensitive);

PICOTEST_SUITE(mainSuite, ALL_TESTS)
PICOTEST_CASE(ALL_TESTS) {
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "one", true),
        "Failed to detect exact CS single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "one", false),
        "Failed to detect exact CI single word suffix"
    );
    PICOTEST_VERIFY(
        !hasSuffix("This is the one", "ONE", true),
        "Detected CS single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "ONE", false),
        "Failed to detect CI single word suffix"
    );
    PICOTEST_VERIFY(
        !hasSuffix("This is the one", "One", true),
        "Detected CS first letter different single word suffix"
    );
    PICOTEST_VERIFY(
        !hasSuffix("This is the one", "oNE", true),
        "Detected CS first letter same single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "One", false),
        "Failed to detect CI first letter different single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "oNE", false),
        "Failed to detect CI first letter same single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("This is the one", "ONE", false),
        "Failed to detect CI single word suffix"
    );
    PICOTEST_VERIFY(
        !hasSuffix("ONE", "one", true),
        "Detected CS single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("ONE", "one", false),
        "Failed to detect CI single word suffix"
    );
    PICOTEST_VERIFY(
        hasSuffix("one", "one", true),
        "Failed to detect CS single word suffix"
    );
    PICOTEST_VERIFY(
        !hasSuffix("One to go", "One", true),
        "Detected CS single word in beginning"
    );
    PICOTEST_VERIFY(
        !hasSuffix("One to go", "One", false),
        "Detected CI single word in beginning"
    );
    PICOTEST_VERIFY(
        !hasSuffix("The one to go", "one", true),
        "Detected CS single word in middle"
    );
    PICOTEST_VERIFY(
        !hasSuffix("The one to go", "One", false),
        "Detected CI single word in middle"
    );
    PICOTEST_VERIFY(
        hasSuffix("The one to go more than one", "one", true),
        "Failed to detect CS suffix when the word previously exists"
    );
    PICOTEST_VERIFY(
        !hasSuffix("one", "Mascarpone", true),
        "Detected CS larger suffix than text"
    );
    PICOTEST_VERIFY(
        !hasSuffix("One", "Mascarpone", false),
        "Detected CI larger suffix than text"
    );
    printf("\nCI : case insensitive"
           "\nCS : case sensitive\n\n");
}

//PICOTEST_SUITE(mainSuite, RANGE_TESTS, BOUNDARY_TESTS)
//
//PICOTEST_CASE(RANGE_TESTS) {
//    int v5in1_2 = !isInRange(5, 1, 2);
//    PICOTEST_VERIFY(v5in1_2, "isInRange(5,1,2) returns unexpected result!");
//    int v5in1_8 = isInRange(5, 1, 8);
//    PICOTEST_VERIFY(v5in1_8, "isInRange(5,1,8) returns unexpected result!");
//}
//PICOTEST_CASE(BOUNDARY_TESTS) {
//    int v5in1_5 = isInRange(5,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(5,1,5) returns unexpected result!");
//    int v1in1_5 = isInRange(1,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(1,1,5) returns unexpected result!");
//}
//PICOTEST_CASE(aktina_0) {
//}
//PICOTEST_CASE(aktina_PI) {
//}
