#include <stdio.h>
#include <float.h>
#include <malloc.h>

double sum(int N, double *A) {
    // Ελέγχω τον pointer
    if (A == NULL) {
        // επιστρέφω μία "απίθανη" τιμή, πχ τη μέγιστη
        // που υποστηρίζει ο double, θα μπορούσατε όμως
        // να επιλέξετε και κάποια αρκετά ακραία τιμή
        // πχ -1e308
        return DBL_MAX;
    }

    // Ελέγχω και το μέγεθος του πίνακα
    if (N < 0) {
        return DBL_MAX;
    }

    // δίνω αρχική τιμή στην μεταβλητή που
    // θα αποθηκεύσω το αποτέλεσμα
    double result = 0;
    // για κάθε στοιχείο του πίνακα
    for (int i = 0; i < N; ++i) {
        // αυξάνω το αποτέλεσμα κατά την
        // τιμή του στοιχείου
        result += A[i];
    }

    // επιστρέφω το αποτέλεσμα
    return result;
}

/*
 * Ο σκοπός είναι να επιστρέφεται ένας πίνακας που
 * κάθε στοιχείο του είναι το άθροισμα των προηγούμενων
 * τοιχείων του αρχικού πίνακα. Π.χ.
 * Α: 1  3  8  4
 * R: 1  4 12 16
 * Σε σχέση με τη sum οι αλλαγές είναι οι ακόλουθες
 */
// αλλάζω να επιστρέφω pointer, αφού επιστρέφω πίνακα
double *cumsum(int N, double *A) {
    // Ελέγχω τον pointer
    if (A == NULL) {
        // Αλλάζει η τιμή που επιστρέφω σε NULL,
        // αφού πλέον η συνάρτηση επιστρέφει pointer
        return NULL;
    }

    // Ελέγχω και το μέγεθος του πίνακα
    if (N < 0) {
        return NULL;
    }

    // Ζητάω μνήμη για έναν πίνακα ίδιων
    // διαστάσεων με τον Α
    double *result = (double *)malloc(sizeof(double)*N);
    if (result == NULL) {
        return NULL;
    }

    // δίνω αρχική τιμή στη μεταβλητή που
    // θα αποθηκεύσω το αποτέλεσμα
    double total = 0;
    // για κάθε στοιχείο του πίνακα
    for (int i = 0; i < N; ++i) {
        // αυξάνω το αποτέλεσμα κατά την
        // τιμή του στοιχείου
        total += A[i];
        result[i] = total;
    }

    // επιστρέφω το αποτέλεσμα
    return result;
}

/*
 * Εδώ όμοια με τη sum, σε σχόλιο
 * μόνο οι διαφορές
 */
double max(int N, double *A) {
    if (A == NULL) {
        return DBL_MAX;
    }

    if (N < 0) {
        return DBL_MAX;
    }

    // υποθέτω ότι το αρχικό στοιχείο είναι
    // το ζητούμενο (εδώ το μέγιστο)
    double result = A[0];
    for (int i = 1; i < N; ++i) {
        // αν το στοιχείο i είναι μεγαλύτερο
        // από το μέχρι τώρα μέγιστο
        if (result < A[i]) {
            // τότε αυτό είναι το νέο μέγιστο
            result = A[i];
        }
    }
    
    return result;
}

long secSinceMidnight(int h, int m, int s) {
    return (h*60 + m)*60 + s;
}

/*
 * Για δεδομένο πλήθος δευτερολέπτων secs που
 * έχει περάσει από τα μεσάνυχτα μέχρι κάποια
 * στιγμή επιστρέφει έναν 6 ψήφιο αριθμό με τη
 * μορφή:
 *
 * HHMMSS
 * π.χ. 081106
 *
 * Δηλαδή τα 2 πρώτα ψηφία είναι οι ώρες που έχουν
 * περάσει (08), τα δύο επόμενα είναι τα λεπτά (11)
 * και τα δύο τελευταία τα δευτερόλεπτα (06).
 */
int seconds2HMS(long secs) {
    int sec = secs % 60;
    secs /= 60;
    int min = secs % 60;
    int hrs = secs / 60;

    return hrs * 10000 + min * 100 + sec;
}

int main() {
    printf("HMS %06d\n", seconds2HMS(10000));
    return 0;
}
