#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Υποθέτουμε ότι η μακρύτερη γραμμή έχει αυτό το μήκος
#define MAXLINE 1024

// μέτρηση γραμμών από το αρχείο με όνομα (ή path/διαδρομή) filename
int countLines(char *filename) {
	// δοκιμάζουμε να το ανοίξουμε
    FILE* f1 = fopen(filename,"r");
	// αν δεν άνοιξε
    if (f1 == NULL) {
		// επίστρεψε μια τιμή που δεν στέκει για μήκος ως ένδειξη σφάλματος
        return -1;
    }

	// δήλωση του πίνακα που θα κρατά τη γραμμή
    char line[MAXLINE];
	// υποθέτουμε αρχικό πλήθος γραμμών 0
    int lineCount = 0;

	// δοκίμασε να διαβάσεις μια γραμμή - και όσο τα καταφέρνεις
    while(fgets(line, MAXLINE, f1) != NULL) {
		// αν ο τελευταίος ( strlen(line) - 1 ) χαρακτήρας του
		// κειμένου είναι αλλαγή γραμμής (δηλαδή η γραμμή χώρεσε στο line
        if (line[ strlen(line) - 1 ] == '\n') {
			// τότε μέτρησε μία γραμμή
            lineCount++;
        }
    }

	// μην ξεχάσεις να κλείσεις το αρχείο
    fclose(f1);

	// επιστροφή του πλήθους των γραμμών
    return lineCount;
}

// "διαγραφή" του πίνακα arr με διαστάσεις R και C
void deleteArray2D(double **arr, int R, int C) {
	// πάντα πρώτα ελέγχουμε μήπως δώθηκε NULL
    if (arr == NULL) {
        return;
    }

	// για κάθε γραμμή
    for (int r = 0; r < R; ++r) {
		// αν δεν είναι NULL η γραμμή
		// (το οποίο συμβαίνει όταν την καλέσει
		//  π.χ. η zeros - επειδή δεν έφτασε η
		//  μνήμη για όλο τον πίνακα)
        if (arr[r] != NULL) {
			// απελευθέρωσε τη σχετική μνήμη
            free(arr[r]);
        }
    }
	
	// απελευθέρωσε και τον βοηθητικό πίνακα
    free(arr);
}

// Δημιουργία πίνακα με μηδενικά στοιχεία
// διαστάσεων R γραμμές και C στήλες
double **zeros(int R, int C) {
	// βοηθητική μεταβλητή με τον πίνακα που θα δημιουργήσουμε
    double **arr;

	// αυτό το προσθέτουμε τώρα - έλλειπε για απλότητα από τη διάλεξη
	// ελέγχουμε τις διαστάσεις να είναι θετικές
	if (R < 1 || C < 1) {
		// αν δεν είναι αποδεκτές, επιστρέφουμε NULL
		return NULL;
	}

	// ζητάω μνήμη για R στοιχεία (ένα για κάθε γραμμή)
	// όπου το κάθε στοιχείο είναι pointer σε double,
	// δηλαδή ο πίνακας γραμμή με στοιχεία double 
    arr = (double **)malloc(R* sizeof(double *));
	// αν δεν υπάρχει μνήμη
    if (arr == NULL) {
		// επιστρέφω NULL
        return NULL;
    }

	// κάθε στοιχείο (pointer σε γραμμή)
    for (int r = 0; r < R; ++r) {
		// το αρχικοποιώ σε NULL
		// (αφού το κάθε ένα είναι pointer)
        arr[r] = NULL;
    }

	// για κάθε γραμμή
    for (int r = 0; r < R; ++r) {
		// δέσμευσε μνήμη για C στοιχεία που έχει η γραμμή, τύπου double
        arr[r] = (double *)malloc(C * sizeof(double));
		// αν δεν βρεθεί μνήμη
        if (arr[r] == NULL) {
			// κάλεσε την deleteArray2D για να απελευθερώσει
			// όλα τα προηγούμενα malloc
            deleteArray2D(arr, R, C);
			// και επίστρεψε NULL
            return NULL;
        }
		// αφού η γραμμή δεσμεύτηκε, για κάθε στοιχείο της
        for (int c = 0; c < C; ++c) {
			// το αρχικοποιώ σε 0 (αφού η συνάρτηση είναι η zeros)
            arr[r][c] = 0.0;
        }
    }

	// επιστρέφουμε τον πίνακα που δημιουργήθηκε
    return arr;
}

// Δημιουργία μοναδιαίου πίνακα NxN
double **eye(int N) {
	// δοκιμάζω να φτιάξω έναν μηδενικό NxN
    double **I = zeros(N,N);
	// αν δεν υπάρχει μνήμη
    if (I == NULL) {
		// επιστρέφουμε NULL
        return NULL;
    }

	// για κάθε στοιχείο της διαγωνίου
	// (που έχει δείκτες γραμμής και στήλης ίσους)
    for (int i = 0; i < N; ++i) {
		// 
        I[i][i] = 1.0;
    }

    return I;
}


int main() {
    printf("Hello, World!\n");
    return 0;
}
