// για να χρησιμοποιώ την printf και το NULL
#include <stdio.h>
// για να χρησιμοποιώ την isalpha
#include <ctype.h>

/**
 *  Επιστρέφει την πρώτη λέξη του κειμένου text.
 *  Εάν ως text δοθεί το NULL, τότε συνεχίζει με την
 *      επόμενη λέξη του προηγούμενου κειμένου.
 *  Εάν βρεθεί η λέξη επιστρέφεται ο pointer στην
 *      αρχή της λέξης, εάν δεν βρεθεί, τότε
 *      επιστρέφεται NULL.
 *  
 *  Στη μεταβλητή (που δείχνει το) L τοποθετείται
 *      το μήκος της λέξης που βρέθηκε. Εάν δοθεί
 *      L ίσο με NULL, τότε δεν υπολογίζεται το
 *      μήκος της λέξης.
 *
 *  Προσοχή! Το βασικό αποτέλεσμα είναι η τιμή που
 *           επιστρέφεται. Εάν αυτή είναι NULL, τότε
 *           ΔΕΝ βρέθηκε λέξη, και σε αυτή την
 *           περίπτωση το L δεν εξετάζεται, ούτε
 *           αλλάζει η τιμή του σε 0.
 */
char *nextWord(char *text, int *L) {
	// η μεταβλητή (στατική) που θυμάται που είχαμε
	// βρει την προηγούμενη λέξη (την αρχή της)
    static char *prevText = NULL;

	// εάν δε δοθεί νέο κείμενο
    if (text == NULL) {
		// και δεν υπάρχει και προηγούμενη λέξη
        if (prevText == NULL) {
			// τότε τίποτα δε βρέθηκε...
            return NULL;
        }
		// συνεχίζουμε από εκεί που είχαμε μείνει
        text = prevText;
		// επειδή όμως είμαστε στην αρχή της λέξης,
		// πρέπει να βγούμε από αυτή. Οπότε όσο δεν
		// έχει τελειώσει το κείμενο
        while (*text != 0) {
			// εάν ο τρέχον χαρακτήρας που δεν
			// είναι γράμμα...
            if (!isalpha(*text)) {
				// τότε βγήκαμε από τη λέξη
                break;
            }
			// αλλιώς (μπορείτε να βάλετε else εδώ
			// για να είναι ξεκάθαρο, αλλά περισσεύει)
			// προχωράμε στον επόμενο χαρακτήρα
            text++;
        }
		// τώρα που τελειώσαμε, είτε βγήκαμε από τη
		// λέξη, είτε τελείωσε το κείμενο.
		// Αν τελείωσε το κείμενο...
        if(*text == 0) {
			// τότε δεν υπάρχει επόμενη λέξη και
			// αποθηκεύω στην prevText ότι δεν υπάρχει
			// κάτι να θυμάται
            prevText = NULL;
			// επιστρέφεται το NULL αφού δεν υπάρχει
			// επόμενη λέξη
            return NULL;
        }
    }

	// είτε είχε δοθεί νέο κείμενο και είμαστε στην
	// αρχή του, είτε συνεχίσαμε το προηγούμενο κείμενο,
	// οπότε μόλις έχουμε βγει από τη λέξη...

	// όσο δεν είμαστε σε λέξη και δεν έχει τελειώσει
	// το κείμενο
    while (!isalpha(*text) && *text != 0) {
		// προχωράμε στον επόμενο χαρακτήρα
        text++;
    }

	// είτε τελείωσε το κείμενο
    if(*text == 0) {
		// οπότε δεν βρέθηκε κάτι (όπως πιο πάνω)
        prevText = NULL;
        return NULL;
    } else {
		// είτε βρέθηκε η αρχή μιας λέξης
		// και την κρατώ στο prevText
        prevText = text;
		// εάν μου ζήτησαν και το μήκος της λέξης
        if (L != NULL) {
			// τότε αρχικά υποθέτω ότι είναι 0
            *L = 0;
			// για κάθε χαρακτήρα μέχρι το τέλος
			// του κειμένου
            while (*text != 0) {
				// ψαχνω για μη αλφαβητικό - δηλαδή
				// αν δεν είναι γράμμα = βγήκα από
				// τη λέξη
                if (!isalpha(*text)) {
					// τότε σταματάω
                    break;
                }
				// αλλιώς προχωράω στον επόμενο
				// χαρακτήρα
                text++;
				// και αυξάνω το μήκος κατά 1
                (*L)++;
            }
        }
		// τώρα που έχω υπολογίσει το μήκος, μπορώ
		// να επιστέψω τον pointer που δείχνει την
		// αρχή της λέξης (βλ. αρχή του else)
        return prevText;
    }
}

int main() {
    int Len = 0;
    char *myText = "San bgeis ston phgaimo gia thn I8aki";
	// βάζουμε πρώτα το μήκος Len και μέτα την nextWord που
	// το υπολογίζει επειδή (για τεχνικούς λόγους) όταν η C
	// καλεί μια συνάρτηση υπολογίζει τα ορίσματα από δεξιά
	// προς τα αριστερά
	//
	// Επίσης οι τελευταίες printf εμφανίζουν (null) επειδή
	// έχουν τελειώσει οι λέξεις του κειμένου και η nextWord
	// επιστρέφει την τιμή NULL - Και βέβαια δεν αλλάζει η
	// τιμή της Len (αφού είναι NULL το αποτέλεσμα)
    printf("%d : %s\n", Len, nextWord(myText, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    printf("%d : %s\n", Len, nextWord(NULL, &Len));
    return 0;
}
