#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <ctype.h>

#define SIZE1024 1024
#define SIZE10 10
#define SIZE15 15

/*
 * Αντιγραφή κειμένου από τον πίνακα from στον πίνακα to.
 * Από τον from αντιγράφουμε μέχρι να βρουμε τον κωδικό 0 που τερματίζει το κείμενο.
 * Στον to αντιγράφουμε όσο χρειάζεται αλλά χωρίς να ξεπεράσουμε το μέγεθός του.
 * Αν (πάμε να) ξεπεράσουμε το μέγεθος, σταματάμε την αντιγραφή βάζοντας το 0 και
 * επιστρέφοντας false ώστε να γνωρίζει όποιος την κάλεσε ότι δεν ολοκληρώθηκε η
 * αντιγραφή.
 * Αλλιώς, η αντιγραφή ολοκληρώθηκε επιτυχώς και επιστρέφουμε true.
 */
bool copyText(char from[], char to[], int lengthOfTo) {
    // δηλώνω την i πριν το for, επειδή θέλω μετά το for να παραμείνει
    // η i ώστε να εξετάσω την τιμή της και να ξέρω ποιός ο λόγος που
    // τερματίστηκε το Loop
    int i;
    // για κάθε θέση i των πινάκων, εφόσον το i είναι εντός των ορίων
    // και δεν βρήκα το τέλος του κειμένου
    for (i = 0; i < lengthOfTo && from[i]!=0; ++i) {
        // αντιγράφω τον κάθε χαρακτήρα
        to[i] = from[i];
    }
    // αν τελείωσα χωρίς να ξεπεράσω τα όρια του πίνακα
    if(i < lengthOfTo) {
        // τοτε βρέθηκε το τέλος του κειμένου και το τοποθετώ και στον πίνακα to
        // ΠΡΟΣΟΧΗ!
        // Το i όταν τερματίστηκε το for, επειδή δεν ήταν λόγω του μεγέθους
        // του πίνακα, ήταν επειδή from[i]!=0 ήταν false, δηλαδή το from[i]
        // ήταν 0. Και το i έδειχνε στη θέση εκείνου του 0. Άρα... βάζω στην
        // ίδια θέση το 0 και στον to
        to[i] = 0;
        // Άρα η αντιγραφή ολοκληρώθηκε επιτυχώς
        return true;
    } else {
        // αλλιώς έφτασα στο όριο του πίνακα to, οπότε τον έχω γεμίσει μέχρι
        // το τέλος του χαρακτήρες. Όμως τα κείμενα ΟΠΩΣΔΗΠΟΤΕ τερματίζονται
        // με το 0, οπότε πάω έναν χαρακτήρα πίσω (ώστε να είμαι στο τέλος
        // του πίνακα) και βάζω εκεί το 0 (γράφοντας πάνω από τον τελευταίο
        // χαρακτήρα που είχα αντιγράψει, αφού ούτως ή άλλως δεν χωρούσε)
        to[i-1] = 0;
        // Άρα η αντιγραφή ήταν ημιτελής
        return false;
    }
}

/*
 * Είναι ο χαρακτήρας a και ο b οι ίδιοι;
 * (εφόσον είναι γράμμα - εννοείται) τα κεφαλαία με τα πεζά μου κάνουν το ίδιο;
 * Αυτό το καθορίζει το caseInsensitive. Όταν είναι true μου κάνουν το ίδιο.
 * Όταν είναι false θεωρώ ότι διαφέρουν.
 */
bool isSameLetter(char a, char b, bool caseInsensitive) {
    // αν ο κωδικός είναι ο ίδιος
    if (a == b) {
        // τότε οπωσδήποτε - εξ'ορισμού - μιλάμε για τον ίδιο χαρακτήρα
        return true;
    } else if (caseInsensitive && isalpha(a) && isalpha(b)) {
        // Αλλιώς αν μου κάνουν το ίδιο τα πεζά με τα κεφαλαία
        // ΚΑΙ το a είναι γράμμα
        // ΚΑΙ το b είναι γραμμα

        // Αν η απόσταση των κωδικών (σε απόλυτο αφού δεν ξέρω ποιός
        // είναι μεγαλύετρος) είναι όσο η απόσταση των πεζών με τα κεφαλαία
        if (abs(a-b) == abs('A'-'a')) {
            // τότε εκ των πραγμάτων είναι ο ίδιος χαρακτήρας
            return true;
        } else {
            // αλλιώς διαφέρει
            return false;
        }
    } else {
        // αφου δεν ταιριάζουν οι κωδικοί και δεν είμαι
        // στην ειδική περίπτωση γραμμάτων ή δεν θεωρώ κεφαλαία και πεζά το ίδιο

        // τότε διαφέρουν
        return false;
    }

    return a==b;
}

int main(void) {
    // Αναλυτική παρουσίαση δήλωσης και ανάθεσης δείκτη
    int a = 123;
    int *Ap;        // Δήλωση
    Ap = &a;        // Ανάθεση


    // Παραδείγματα της isSameLetter
    printf("A vs q -> %s\n", isSameLetter('A','q',false)?"Idia":"Diaforetika");
    printf("F vs f -> %s\n", isSameLetter('F','f',false)?"Idia":"Diaforetika");
    printf("E vs e -> %s\n", isSameLetter('E','e',true)?"Idia":"Diaforetika");
    printf("Z vs Z -> %s\n", isSameLetter('Z','Z',true)?"Idia":"Diaforetika");
    printf("x vs x -> %s\n", isSameLetter('x','x',true)?"Idia":"Diaforetika");

    // Ας αφήσουμε λίγο χώρο
    printf("\n\n\n");

    // Παραδείγματα της copyText
    char t[] = "This is a text";
    char b[SIZE1024];
    char c[SIZE10];
    char d[SIZE15];

    // Αντιγράφω το κείμενο σε μεγάλο πίνακα
    bool t2b = copyText(t, b, SIZE1024);
    bool t2c = copyText(t, c, SIZE10);
    bool t2d = copyText(t, d, SIZE15);

    printf("t: %s\n",t);
    printf("b: %s\n",b);
    printf("c: %s\n",c);
    printf("d: %s\n",d);
    printf("\n");
    printf("t2b: %s\n", t2b ? "Ok" : "Truncated");
    printf("t2c: %s\n", t2c ? "Ok" : "Truncated");
    printf("t2d: %s\n", t2d ? "Ok" : "Truncated");

    return 0;
}
