#include <stdio.h>
#include <stdlib.h>

typedef struct _node {
    struct _node *left;
    struct _node *right;
    char value;
} Node;

Node *createTree(char *s, int *pos) {
    Node *NN = (Node *)malloc(sizeof(Node));
    NN->value = s[*pos];
    if (NN->value != 0) {
        NN->left = NN->right = NULL;
        (*pos)++;
    } else {
        (*pos)++;
        NN->right = createTree(s, pos);
        NN->left = createTree(s, pos);
    }
    return NN;
}

int treeHeight(Node *root) {
    int Lh, Rh;

    if (!root)
        return -1;

    Lh = treeHeight(root->left);
    Rh = treeHeight(root->right);
    if (Lh > Rh)
        return Lh+1;
    else
        return Rh+1;
}

int findInTree(Node *tree, unsigned char val, int *byte, int *bits, int currBits, int bitCnt) {
    int res;

    if (!tree) res=0;
    else if (tree->value == val) {
        *byte = ((*byte) << bitCnt) | currBits;
        *bits += bitCnt;
        res=1;
    } else if (findInTree(tree->left, val, byte, bits, currBits << 1 | 0, bitCnt+1) == 1) {
        res=1;
    } else if (findInTree(tree->right, val, byte, bits, currBits << 1 | 1, bitCnt+1) == 1) {
        res=1;
    } else res=0;
    return res;
}

int compress(unsigned char *in, unsigned char *out, Node *tree) {
    int Byte=0;
    int totalOUTbits = 0;
    int bitCount = 0;
    int dataByte = 0;
    int outCount = 0;

    while( in[Byte] != 0 ) {
        if (findInTree(tree, in[Byte], &dataByte, &bitCount, 0, 0) == 0) {
            return -1;
        }
        if (bitCount >= 8) {
            out[outCount++] = (dataByte & (255 << (bitCount-8))) >> (bitCount-8);
            if (bitCount == 8)
                dataByte = 0;
            else
                dataByte = dataByte & ((1<<(bitCount-8))-1);
            bitCount -= 8;
            totalOUTbits += 8;
        }
        Byte++;
    }
    if (bitCount > 0) {
        dataByte <<= 7 - bitCount;
        out[outCount++] = dataByte;
        totalOUTbits += bitCount;
    }
    return totalOUTbits;
}

int decompress(unsigned char *in, int BL, unsigned char *out, Node *tree) {
    int bitPos = 7;
    int inPos = 0;
    int outPos = 0;
    Node *currNode = tree;
    int bitsInByte = (BL < 8)? BL : 8;

    while ( BL > 0 ) {
        if (in[inPos] & (1 << bitPos)) {
            printf("1");
            currNode = currNode->right;
        } else {
            printf("0");
            currNode = currNode->left;
        }

        if (currNode->value != 0) {
            out[outPos++] = currNode->value;
            printf("%c",out[outPos-1]);
            currNode = tree;
        }

        bitPos--;
        bitsInByte--;
        BL--;

        if (bitsInByte == 0) {
            bitsInByte = (BL < 8)? BL : 8;
            bitPos = 7;
            inPos++;
        }
    }
    printf("\n");
    if (currNode != tree) printf("WARNING: CURR NODE\n");
    if (bitPos != 7) printf("WARNING: Bits remaining!\n");
    out[outPos++] = 0;
    return outPos;
}

void hexDump(unsigned char *b, int L) {
    int i = 0;
    while (i < L) {
        printf("%02x ", b[i]);
        i++;
        if (i%16 == 0) printf("\n");
    }
}
void binDump(unsigned char *b, int L) {
    int i = 0;
    while (i < L) {
        printf("%d%d%d%d %d%d%d%d ",
               (b[i] & 128)/128,
               (b[i] & 64)/64,
               (b[i] & 32)/32,
               (b[i] & 16)/16,
               (b[i] & 8)/8,
               (b[i] & 4)/4,
               (b[i] & 2)/2,
               (b[i] & 1));
        i++;
        if (i%8 == 0) printf("\n");
    }
    printf("\n");
}
int example() {
    char tree_data[] = {0,'*',0,' ',0,'|','\n'};
    int pos = 0;
    int H;
    int bL;
    unsigned char *text = "|* ** *** ****|\n| ** * ** *** |\n| *** ** * ** |\n|**** *** ** *|\n";
    unsigned char buf[1024];
    unsigned char decompressed[1024];
    int deCnt;

    Node *root = createTree(tree_data, &pos);

    printf("Compressing\n");

    bL = compress(text, buf, root);

    hexDump(buf, bL/8+1);

    binDump(buf, bL/8+1);

    printf("Decompressing\n");

    deCnt = decompress(buf, bL, decompressed, root);

    printf("Bytes %d\n", deCnt);
    printf("Text\n%s\n", decompressed);

    return 0;

}