#include <stdio.h>
#include <stdlib.h>

int *charStats(char *filepath) {
    int *stats = (int *)malloc(256*sizeof(int));
    FILE *F = fopen(filepath, "r");
    int c;

    if (!stats || !F) {
        if (!F) fclose(F);
        if (!stats) free(stats);
        return NULL;
    }

    for(c=0;c<256;c++) {
        stats[c] = 0;
    }

    while ((c = fgetc(F)) != EOF) {
        stats[c]++;
    }

    fclose(F);

    return stats;
}

int example() {
    int i;
    int *stats = charStats("../demo-files/test.txt");
    if (stats == NULL) {
        printf("File failure\n");
        return 1;
    } else {
        printf("Stats Ok!\n");
    }

    for (i=0; i < 256; i++) {
        if (stats[i] > 0) {
            printf("%d (%c) : %d\n",i,i,stats[i]);
        }
    }

    free(stats);
    return 0;
}