#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define LINE_SPACE 120

typedef struct _node {
    struct _node *left;
    struct _node *right;
    double value;
} Node;

int treeHeight(Node *root) {
    int Lh, Rh;

    if (!root)
        return -1;

    Lh = treeHeight(root->left);
    Rh = treeHeight(root->right);
    if (Lh > Rh)
        return Lh+1;
    else
        return Rh+1;
}

Node * createNode(double val) {
    Node *n = (Node *)malloc(sizeof(Node));
    if (!n) return NULL;
    n->right = n->left = NULL;
    n->value = val;
    return n;
}

Node * treeInsert(Node *root, double val) {
    if (!root) {
        return createNode(val);
    }

    if (root->value > val || root->value == val && (rand()&1))
        root->left = treeInsert(root->left, val);
    else
        root->right = treeInsert(root->right, val);

    return root;
}

void showTree(Node *root, int level, int space) {
    int i;
    if (level == 1) {
        for (i=0; i<space/2; i++) printf(" ");
        if (root)
            printf(" %2.3lf ", root->value);
        else
            printf(" ----- ");
        for (i=0; i<space/2; i++) printf(" ");
    } else {
        if (root) {
            showTree(root->left, level-1, space/2-3);
            showTree(root->right, level-1, space/2-3);
        } else {
            showTree(NULL, level-1, space/2-3);
            showTree(NULL, level-1, space/2-3);
        }
    }
}

Node *findInTree(Node *root, double val) {
    Node *hlp;
    if (!root)
        return NULL;
    else if (root->value == val)
        return root;
    else if (hlp=findInTree(root->left, val))
        return hlp;
    else if (hlp=findInTree(root->right, val))
        return hlp;
    else
        return NULL;
}
Node *findParentInTree(Node *root, Node *n) {
    Node *hlp;
    if (!root)
        return NULL;
    else if (root == n)
        return NULL;
    else if (root->left == n || root->right == n)
        return root;
    else if (hlp=findParentInTree(root->left, n))
        return hlp;
    else if (hlp=findParentInTree(root->right, n))
        return hlp;
    else
        return NULL;
}
void RelinkToParent(Node *p, Node *n, Node *r) {
    if (p) {
        if (p->left == n)
            p->left = r;
        else if (p->right == n)
            p->right = r;
    }
}
Node *deleteFromTree(Node *root, Node *n) {
    //Node *n = findInTree(root, val);
    Node *p = findParentInTree(root, n);
    int Lh, Rh;

    if (n) {
        if (n->left == NULL && n->right == NULL) {
            RelinkToParent(p, n, NULL);
            if (root == n)
                return NULL;
            return root;
        } else if (n->left == NULL) {
            RelinkToParent(p, n, n->right);
            if (root == n)
                return n->right;
            return root;
        } else if (n->right == NULL) {
            RelinkToParent(p, n, n->left);
            if (root == n)
                return n->left;
            return root;
        } else {
            Lh = treeHeight(n->left);
            Rh = treeHeight(n->right);
            if (Lh < Rh) {
                n->value = n->right->value;
                deleteFromTree(root, n->right);
            } else {
                n->value = n->left->value;
                deleteFromTree(root, n->left);
            }
            return root;
        }
    } else {
        return root;
    }
}

Node *TestDelete(Node *root, double v, int LS) {
    Node *h = findInTree(root, v);
    Node *hlp;
    if (!h) {
        printf("%lf NOT found!\n", v);
        return root;
    }

    printf("Found %x\n", h);
    if (hlp = deleteFromTree(root, h)) {
        root = hlp;
        showTree(root,1,LS);printf("\n");
        showTree(root,2,LS);printf("\n");
        showTree(root,3,LS);printf("\n");
        showTree(root,4,LS);printf("\n");
        showTree(root,5,LS);printf("\n");
    } else {
        printf("Deletion FAILED!\n");
    }
    return root;
}

int treeMinHeight(Node *root) {
    int Lmh, Rmh;

    if (root->left == NULL && root->right == NULL) {
        return 0;
    } else if (root->right == NULL) {
        return treeMinHeight(root->left)+1;
    } else if (root->left == NULL) {
        return treeMinHeight(root->right)+1;
    } else {
        Lmh = treeMinHeight(root->left);
        Rmh = treeMinHeight(root->right);

        if (Lmh < Rmh) {
            return Lmh+1;
        } else {
            return Rmh+1;
        }
    }
}

int example() {
    int i;
    int LS = LINE_SPACE;
    Node *root;
    double best[] = { 4.0, 12.0, 2.0, 6.0, 10.0, 14.0, 1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0 };

    printf("------------------------  B E S T   S E Q U E N C E   V A L U E S  ------------------------\n");
    root = treeInsert(NULL, 8);
    for (i=0; i<14; i++)
        treeInsert(root, best[i]);

    showTree(root,1,LS);printf("\n");
    showTree(root,2,LS);printf("\n");
    showTree(root,3,LS);printf("\n");
    showTree(root,4,LS);printf("\n");
    showTree(root,5,LS);printf("\n");

    root = TestDelete(root, 9, LS);
    root = TestDelete(root, 10, LS);
    root = TestDelete(root, 11, LS);
    root = TestDelete(root, 14, LS);
    root = TestDelete(root, 6, LS);
    root = TestDelete(root, 4, LS);
    root = TestDelete(root, 8, LS);
    root = TestDelete(root, 15, LS);

    printf("Tree Min and Max Height: %d , %d\n", treeMinHeight(root), treeHeight(root));

    return 0;
}