#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define LINE_SPACE 120

typedef struct _node {
    struct _node *left;
    struct _node *right;
    double value;
} Node;

int treeHeight(Node *root) {
    int Lh, Rh;

    if (!root)
        return -1;

    Lh = treeHeight(root->left);
    Rh = treeHeight(root->right);
    if (Lh > Rh)
        return Lh+1;
    else
        return Rh+1;
}

Node * createNode(double val) {
    Node *n = (Node *)malloc(sizeof(Node));
    if (!n) return NULL;
    n->right = n->left = NULL;
    n->value = val;
    return n;
}

Node * treeInsert(Node *root, double val) {
    if (!root) {
        return createNode(val);
    }

    if (root->value > val || root->value == val && (rand()&1))
        root->left = treeInsert(root->left, val);
    else
        root->right = treeInsert(root->right, val);

    return root;
}

void showTree(Node *root, int level, int space) {
    int i;
    if (level == 1) {
        for (i=0; i<space/2; i++) printf(" ");
        if (root)
            printf(" %2.3lf ", root->value);
        else
            printf(" ----- ");
        for (i=0; i<space/2; i++) printf(" ");
    } else {
        if (root) {
            showTree(root->left, level-1, space/2-3);
            showTree(root->right, level-1, space/2-3);
        } else {
            showTree(NULL, level-1, space/2-3);
            showTree(NULL, level-1, space/2-3);
        }
    }
}

int example() {
    int i;
    int LS = LINE_SPACE;
    int SD = 1000;
    Node *root;
    double best[] = { 4.0, 12.0, 2.0, 6.0, 10.0, 14.0, 1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0 };

    printf("SD: %d , LS: %d\n\n", SD, LS);

    srand(SD);

    printf("------------------------  R A N D O M   V A L U E S  ------------------------\n");
    root = treeInsert(NULL, rand()*10.0/RAND_MAX);
    for (i=0; i<12; i++)
        treeInsert(root, rand()*10.0/RAND_MAX);

    showTree(root,1,LS);printf("\n");
    showTree(root,2,LS);printf("\n");
    showTree(root,3,LS);printf("\n");
    showTree(root,4,LS);printf("\n");
    showTree(root,5,LS);printf("\n");

    printf("------------------------  I N C R E M E N T I N G   V A L U E S  ------------------------\n");
    root = treeInsert(NULL, 1.0);
    for (i=0; i<4; i++)
        treeInsert(root, 1.0+i);

    showTree(root,1,LS);printf("\n");
    showTree(root,2,LS);printf("\n");
    showTree(root,3,LS);printf("\n");
    showTree(root,4,LS);printf("\n");
    showTree(root,5,LS);printf("\n");

    printf("------------------------  B E S T   S E Q U E N C E   V A L U E S  ------------------------\n");
    root = treeInsert(NULL, 8);
    for (i=0; i<14; i++)
        treeInsert(root, best[i]);

    showTree(root,1,LS);printf("\n");
    showTree(root,2,LS);printf("\n");
    showTree(root,3,LS);printf("\n");
    showTree(root,4,LS);printf("\n");
    showTree(root,5,LS);printf("\n");


    return 0;
}