#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define SZ 100

int binarySearch(double *a, int n, double item) {
    int bottom = 1;
    int top = n;
    int mid;

    do {
        mid = (bottom + top) / 2;
        if (item < a[mid])
            top = mid - 1;
        else if (item > a[mid])
            bottom = mid + 1;
    } while (item != a[mid] && bottom <= top);

    if (item == a[mid]) {
        return mid;
    } else {
        return -1;
    }
}

int example() {
    double arr[SZ];
    int i;
    int r;

    for (i=0; i<SZ; i++) {  // Generate a sorted array
        arr[i] = i + rand()/(double)RAND_MAX;
    }

    r = binarySearch(arr, SZ, arr[17]);
    if (r == -1)
        printf("Value NOT found!\n");
    else
        printf("Value %lf found at position: %d\n", arr[17], r);
    r = binarySearch(arr, SZ, 88.8);
    if (r == -1)
        printf("Value NOT found!\n");
    else
        printf("Value %lf found at position: %d\n", 88.8, r);

    return 0;
}