#include <stdio.h>
#include <stdlib.h>

typedef struct _node {
    struct _node *next;
    struct _node *prev;
    double data;
} Node;

typedef struct _queue { // Same as LIST
    struct _node *head;
    struct _node *tail;
} Queue;

Queue *createQueue() {
    Queue *q = (Queue *)malloc(sizeof(Queue));
    if (!q) return NULL;
    q->head = NULL;
    q->tail = NULL;
    return q;
}

void showQueue(Queue *q) {
    printf("QUEUE ---------------------------------\n");
    Node *n = q->head;
    while (n) {
        printf("%lf\n", n->data);
        n = n->next;
    }
}

int Enqueue(Queue *q, double element) {
    Node *n = (Node *)malloc(sizeof(Node));
    if (!n)
        return 1;
    n->next = q->head;
    n->prev = NULL;
    if (q->head)
        q->head->prev = n;
    q->head = n;
    if (q->tail == NULL)
        q->tail = n;
    n->data = element;
    return 0;
}

double Dequeue(Queue *q) {
    double r;
    Node *t;
    if (q->tail == NULL)
        return -10000;
    r = q->tail->data;
    t = q->tail;
    q->tail = t->prev;
    if (t->prev)
        t->prev->next = NULL;
    else
        q->head = NULL;
    free(t);
    return r;
}

int example() {
    Queue *q = createQueue();
    int i;

    for(i=0; i<10; i++)
        if (Enqueue(q, i+i/10.0))
            printf("Error Enqueueing!\n");

    printf("Enqueue Complete!\n");
    showQueue(q);
    printf("Dequeueing!\n");

    for(i=0; i<10; i++)
        printf("%lf\n", Dequeue(q));

    return 0;

}