#include <stdio.h>
#include <stdlib.h>

typedef struct _node { struct _node *next; double data; } Node;

typedef struct _stack { struct _node *head; } Stack;

int push(Stack *s, double L) {
    Node *n = (Node *)malloc(sizeof(Node));
    if (!n) return 1;
    n->data = L;
    n->next = s->head;
    s->head = n;
    return 0;
}

double pop(Stack *s) {
    struct _node *n = s->head;
    s->head = n->next;
    double L = n->data;
    free(n);
    return L;
}
double peek(Stack *s) { return s->head->data; }
int hasOne(Stack *s) {
    return s->head != NULL && s->head->next == NULL;
}
int isOp(char c) {
    return c=='+' || c=='-' || c=='*' || c=='/';
}
void showStack(Stack *s) {
    Node *h;
    printf("STACK--------------------------------------\n");
    h = s->head;
    while(h) {
        printf( "    %lf - %c\n", h->data, (char)(h->data) );
        h = h->next;
    }
}

int calcOne(Stack *s) {
    char op;
    double d1, d2;

    op = (char)pop(s);
    if (isOp((char)peek(s))) {
        if (calcOne(s) != 0)
            return -40000;
    }
    d1 = pop(s);
    if (isOp((char)peek(s))) {
        if (calcOne(s) != 0)
            return -50000;
    }
    d2 = pop(s);
    switch(op) {
        case '+':
            push(s,d1+d2);
            break;
        case '-':
            push(s,d1-d2);
            break;
        case '*':
            push(s,d1*d2);
            break;
        case '/':
            if (d2 == 0.0) {
                return -20000;
            }
            push(s,d1/d2);
            break;
        default:
            return -30000;
            break;
    }

    return 0;
}
double calc(Stack *s) {
    while (!hasOne(s) && calcOne(s) == 0) {
    }

    if (s->head == NULL)
        return -10000;
    if (!hasOne(s))
        return -60000;

    return pop(s);
}

int example() {
    Stack s;
    s.head = NULL;

    push(&s, 11.0);
    push(&s, 0.1);
    push(&s, (double)'+');
    push(&s, 11.1);
    push(&s, 22.2);
    push(&s, (double)'+');
    push(&s, (double)'/');

    printf("The result is : %lf\n", calc(&s));

    return 0;
}