#include <stdio.h>
#include <stdlib.h>

typedef struct _node {
    struct _node *next;
    double data;
} Node;

typedef struct _stack { // Same as LIST
    struct _node *head;
} Stack;

int push(Stack *s, double L) {
    Node *n = (Node *)malloc(sizeof(Node));
    if (!n)
        return 1;
    n->data = L;
    n->next = s->head;
    s->head = n;
    return 0;
}

double pop(Stack *s) {
    struct _node *n = s->head;
    s->head = n->next;
    double L = n->data;
    free(n);
    return L;
}

int example() {
    Stack s;
    s.head = NULL;

    push(&s, 123.45);
    push(&s, 234.56);
    push(&s, (double)'+');

    printf("%c\n", (char)pop(&s));
    printf("%lf\n", pop(&s));
    printf("%lf\n", pop(&s));

    return 0;
}