#include <stdio.h>
#include <stdlib.h>

typedef struct _mtrx { int M; int N; double **data; } Matrix;


void deleteMx(Matrix *mx) {
    int i;
    if (mx) {
        if (mx->data) {
            for (i=0; i<mx->M; i++) {
                if (mx->data[i])
                    free(mx->data[i]);
            }
            free(mx->data);
        }
        free(mx);
    }
}

Matrix *newEmptyMx(int m, int n) {
    int i, j;
    Matrix *mtrx = (Matrix *)malloc(sizeof(Matrix));
    if (!mtrx) return NULL;

    mtrx->M = m;
    mtrx->N = n;

    mtrx->data = (double **)malloc(sizeof (double *) * m);
    if (!mtrx->data) {
        deleteMx(mtrx);
        return NULL;
    }

    for (i=0; i<m; i++) {
        mtrx->data[i] = (double *)malloc(sizeof(double) * n);
        if (!mtrx->data[i]) {
            deleteMx(mtrx);
            return NULL;
        } else {
            for (j=0; j<n; j++)
                mtrx->data[i][j] = 0.0;
        }
    }

    return mtrx;
}

Matrix *newIMx(int n) {
    int i;
    Matrix *m = newEmptyMx(n,n);

    if(!m) return NULL;

    for(i=0; i<n; i++)
        m->data[i][i] = 1.0;

    return m;
}

void ShowMx(Matrix *m) {
    int i,j;

    for(i=0; i<m->M; i++) {
        for(j=0; j<m->N; j++) {
            printf("%2.3lf ", m->data[i][j]);
        }
        printf("\n");
    }
}

void SwapRowsMx(int i, int j, Matrix *mx) {
    double *help;

    help = mx->data[i];
    mx->data[i] = mx->data[j];
    mx->data[j] = help;
}

void SwapColsMx(int i, int j, Matrix *mx) {
    double help;
    int k;

    for (k=0; k<mx->M; k++) {
        help = mx->data[k][i];
        mx->data[k][i] = mx->data[k][j];
        mx->data[k][j] = help;
    }
}

int TransposeMx(Matrix *mx) {
    int L, S;
    int rszCols;
    int i, j;
    double help3, *help, **help2;

    // Check largest dimension
    if (mx->M > mx->N) {
        L = mx->M;
        S = mx->N;
        rszCols = 1;
    } else {
        L = mx->N;
        S = mx->M;
        rszCols = 0;
    }

    // Resize to a big square
    if (rszCols) {
        for(i=0; i<mx->M; i++) {
            help = (double *)realloc(mx->data[i] , sizeof(double ) * L);
            if (!help) {
                deleteMx(mx);
                return 0;
            }
            mx->data[i] = help;
        }
    } else {
        help2 = (double **)realloc(mx->data, sizeof(double *)*L);
        if (!help2) {
            deleteMx(mx);
            return 0;
        }
        mx->data = help2;
        for (i=mx->M; i<L; i++) {
            mx->data[i] = (double *)malloc(sizeof(double) * L);
            if (!mx->data[i]) {
                deleteMx(mx);
                return 0;
            }
        }
    }

    // Do transpose everything (even nonsense data)
    for(i=0; i<L; i++) {
        for(j=0; j<i; j++) {
            help3 = mx->data[i][j];
            mx->data[i][j] = mx->data[j][i];
            mx->data[j][i] = help3;
        }
    }

    // Now crop extra data
    if (rszCols) {
        for (i=S; i<L; i++) {
            if (mx->data[i]) free( mx->data[i] );
        }
        help2 = (double **)realloc(mx->data, sizeof(double *)*S);
        if (!help2) {
            deleteMx(mx);
            return 0;
        }
        mx->data = help2;
    } else {
        for (i=0; i<L; i++) {
            help = (double *)realloc(mx->data[i], sizeof(double)*S);
            if (!help) {
                deleteMx(mx);
                return 0;
            }
            mx->data[i] = help;
        }
    }

    // Fix matrix size
    L = mx->M;
    mx->M = mx->N;
    mx->N = L;

    return 1;
}

int example() {
    Matrix *I = newIMx(5);
    printf("Part I\n");
    SwapRowsMx(1,3, I);
    //SwapColsMx(0,2, I);
    ShowMx(I);
    deleteMx(I);

    printf("Part II-a\n");
    I = newEmptyMx(3,8);
    I->data[2][5] = 1.23;
    I->data[0][7] = 2.34;
    I->data[1][4] = 8.88;
    I->data[1][2] = 3.45;
    ShowMx(I);
    TransposeMx(I);
    printf("Part II-b\n");
    ShowMx(I);
    deleteMx(I);

    return 0;
}