#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define ARR_SZ 10

double randAB(double a, double b) {
    return a + rand()*(b-a)/RAND_MAX;
}

void randArray(double a[], int size, double m, double M) {
    for (; size > 0; ) {
        a[--size] = randAB(m,M);
    }
}

void printArray(double a[], int size) {
    int i;
    for (i=0; i<size; i++) printf("%2.3lf ",a[i]);
    printf("\n");
}

double sumAllPositives(double a[], int size) {
    double s = 0.0;
    int i;

    for (i=0; i<size; i++) {
        if (a[i] < 0)
            continue;
        s += a[i];
    }
    return s;
}

double sumFirstPositives(double a[], int size) {
    double s = 0.0;
    int i;

    for (i=0; i<size; i++) {
        if (a[i] < 0)
            break;
        s += a[i];
    }
    return s;
}

int example() {

    double a[ARR_SZ];

    srand((unsigned) time(0));  // Trick to setup the random seed by the computer time

    randArray(a,ARR_SZ,-5,15);
    printArray(a,ARR_SZ);

    printf("\n\nSum All + : %2.3lf", sumAllPositives(a,ARR_SZ));
    printf("\n\nSum First + : %2.3lf", sumFirstPositives(a,ARR_SZ));

    return 0;
}
