// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

int emptyB[3][3] = {
        { BLANK, BLANK, BLANK },
        { BLANK, BLANK, BLANK },
        { BLANK, BLANK, BLANK }
};
int finishedB1[3][3] = {
        { playerX, playerX, playerX },
        { playerO, playerO, playerX },
        { playerO, playerO, playerX }
};
int finishedB1x[3][3] = {
        { playerX, playerO, playerX },
        { playerO, playerO, playerX },
        { playerX, playerX, playerO }
};

int finishedB2bad[3][3] = {
        { playerX, playerX, playerX },
        { playerO, playerO, playerX },
        { playerX, playerO, playerX }
};

int finishedB3bad[3][3] = {
        { playerX, playerX, playerO },
        { playerO, playerO, playerX },
        { playerO, playerO, playerX }
};

int NOTfinishedB4bad[3][3] = {
        { playerX, playerX,   BLANK },
        { playerO,   BLANK, playerX },
        {   BLANK, playerO, playerX }
};

int NOTfinishedB5bad[3][3] = {
        { playerX, playerX,   BLANK },
        {   BLANK,   BLANK, playerX },
        {   BLANK, playerO, playerX }
};

int NOTfinishedB6bad[3][3] = {
        { playerX, playerO,   BLANK },
        {   BLANK,   BLANK, playerO },
        {   BLANK, playerO, playerX }
};

int unfinishedB7playsX[3][3] = {
        { playerO,   BLANK, BLANK },
        {   BLANK, playerX, BLANK },
        {   BLANK,   BLANK, BLANK },
};

int unfinishedB8playsO[3][3] = {
        { playerO,   BLANK, BLANK },
        {   BLANK, playerX, BLANK },
        { playerX,   BLANK, BLANK },
};

int brokenB9[3][3] = {
        { playerX, playerO,   BLANK },
        {   BLANK,       3, playerX },
        {   BLANK, playerO, playerX }
};

int playNwinXat00B10[3][3] = {
        { BLANK, playerX, playerX },
        { BLANK, playerO, playerO },
        { BLANK,   BLANK,   BLANK }
};

int playNwinOat10B11[3][3] = {
        { BLANK, playerX, playerX },
        { BLANK, playerO, playerO },
        { BLANK,   BLANK, playerX }
};

int playNwinOat22B12[3][3] = {
        { playerO, playerX, playerO },
        {   BLANK, playerO, playerX },
        { playerX, playerX,   BLANK }
};

bool checkBoard2be(int board[3][3], smString correct) {
    smString map = "-XO";
    for (int i = 0; i < 3; ++i) {
        for (int j = 0; j < 3; ++j) {
            if (map[board[i][j]] != correct[i * 4 + j]) {
                return false;
            }
        }
    }
    return true;
}

PICOTEST_SUITE(mainSuite, FINISHED, PLAYABLE, CAN_PLAY, RC2INT, MOVEnWIN)
PICOTEST_CASE(FINISHED) {
    PICOTEST_VERIFY(isFinished(finishedB1), smMsg(5, "test_5-1-1-a", "A finished board is not detected (XXX|OOX|OOX)"))
    PICOTEST_VERIFY(isFinished(finishedB1x), smMsg(5, "test_5-1-1-a", "A finished board is not detected (XOX|OOX|XXO)"))
    PICOTEST_VERIFY(isFinished(finishedB2bad), smMsg(5, "test_5-1-1-b", "A (bad) finished board is not detected (XXX|OOX|XOX)"))
    PICOTEST_VERIFY(isFinished(finishedB3bad), smMsg(5, "test_5-1-1-b", "A (bad) finished board is not detected (XXO|OOX|OOX)"))
    PICOTEST_VERIFY(!isFinished(NOTfinishedB4bad), smMsg(5, "test_5-1-1-c", "An unfinished board is not detected (XX-|O-X|-OX)"))
    PICOTEST_VERIFY(!isFinished(NOTfinishedB5bad), smMsg(5, "test_5-1-1-d", "A (bad) unfinished board is not detected (XX-|--X|-OX)"))
    PICOTEST_VERIFY(!isFinished(NOTfinishedB6bad), smMsg(5, "test_5-1-1-d", "A (bad) unfinished board is not detected (XO-|--O|-OX)"))
}

PICOTEST_CASE(PLAYABLE) {
    PICOTEST_VERIFY(isPlayablePos(emptyB, 1,1), smMsg(5,  "test_5-1-2-a", "An empty board (---|---|---) isn't playable at 1,1 ?!"))
    PICOTEST_VERIFY(isPlayablePos(emptyB, 2,0), smMsg(5,  "test_5-1-2-a", "An empty board (---|---|---) isn't playable at 2,0 ?!"))
    PICOTEST_VERIFY(isPlayablePos(emptyB, 0,2), smMsg(5,  "test_5-1-2-a", "An empty board (---|---|---) isn't playable at 0,2 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(emptyB, 0,3), smMsg(5,  "test_5-1-2-b", "An empty board (---|---|---) is playable at 0,3 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(emptyB, 3,1), smMsg(5,  "test_5-1-2-b", "An empty board (---|---|---) is playable at 3,1 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(finishedB1, 1,1), smMsg(5,  "test_5-1-2-c", "A finished board (XXX|OOX|OOX) is playable at 1,1 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(finishedB1, 4,4), smMsg(5,  "test_5-1-2-c", "A finished board (XXX|OOX|OOX) is playable at 4,4 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(finishedB2bad, 4,4), smMsg(5,  "test_5-1-2-d", "A (bad) finished board (XXX|OOX|XOX) is playable at 4,4 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(finishedB2bad, 1,1), smMsg(5,  "test_5-1-2-d", "A (bad) finished board (XXX|OOX|XOX) is playable at 1,1 ?!"))
    PICOTEST_VERIFY(isPlayablePos(NOTfinishedB4bad, 1, 1), smMsg(5,  "test_5-1-2-e", "An unfinished board (XX-|O-X|-OX) isn't playable at 1,1 ?!"))
    PICOTEST_VERIFY(!isPlayablePos(NOTfinishedB4bad, 0, 0), smMsg(5,  "test_5-1-2-ff", "An unfinished board (XX-|O-X|-OX) is playable at 0,0 ?!"))
    PICOTEST_VERIFY(isPlayablePos(NOTfinishedB5bad,1,0), smMsg(5,  "test_5-1-2-g", "A (bad-it's ok) unfinished board (XX-|--X|-OX) isn't playable at 1,0"))
    PICOTEST_VERIFY(!isPlayablePos(NOTfinishedB5bad,0,1), smMsg(5,  "test_5-1-2-h", "A (bad-it's ok) unfinished board (XX-|--X|-OX) is playable at 0,1"))
}

PICOTEST_CASE(CAN_PLAY) {
    PICOTEST_VERIFY(canPlay(emptyB,0,0,playerX), smMsg(5,  "test_5-1-3-a", "An empty board cannot play X at 0,0!"))
    PICOTEST_VERIFY(canPlay(emptyB,2,2,playerX), smMsg(5,  "test_5-1-3-a", "An empty board cannot play X at 2,2!"))
    PICOTEST_VERIFY(!canPlay(emptyB,0,3,playerX), smMsg(5,  "test_5-1-3-b", "An empty board can play X at 0,3!"))
    PICOTEST_VERIFY(!canPlay(emptyB,3,0,playerX), smMsg(5,  "test_5-1-3-b", "An empty board can play X at 3,0!"))
    PICOTEST_VERIFY(!canPlay(emptyB,1,1,playerO), smMsg(5,  "test_5-1-3-c", "An empty board can play O at 1,1!"))
    PICOTEST_VERIFY(!canPlay(finishedB3bad,1,2,playerX), smMsg(5,  "test_5-1-3-d", "An finished bad board (XXO|OOX|OOX) can play X at 1,2!"))
    PICOTEST_VERIFY(!canPlay(finishedB3bad,2,1,playerX), smMsg(5,  "test_5-1-3-d", "An finished bad board (XXO|OOX|OOX) can play O at 2,1!"))
    PICOTEST_VERIFY(canPlay(unfinishedB7playsX,2,0,playerX), smMsg(5,  "test_5-1-3-e", "Board (O--|-X-|---) cannot play X at 2,0!"))
    PICOTEST_VERIFY(!canPlay(unfinishedB7playsX,2,0,playerO), smMsg(5,  "test_5-1-3-f", "Board (O--|-X-|---) can play O at 2,0!"))
    PICOTEST_VERIFY(!canPlay(unfinishedB8playsO,2,0,playerX), smMsg(5,  "test_5-1-3-f", "Board (O--|-X-|X--) can play X at 2,0!"))
    PICOTEST_VERIFY(canPlay(unfinishedB8playsO,0,2,playerO), smMsg(5,  "test_5-1-3-e", "Board (O--|-X-|X--) cannot play O at 0,2!"))
    PICOTEST_VERIFY(!canPlay(brokenB9,0,2,playerO), smMsg(5,  "test_5-1-3-g", "Board (XO-|-3X|-OX) can play O at 0,2!"))
}

PICOTEST_CASE(RC2INT) {
    PICOTEST_VERIFY(rc2int(0,0) == 0, smMsg(5,  "test_5-1-4-a", "rc2int didn't convert 0,0 to 0"))
    PICOTEST_VERIFY(rc2int(0,1) == 1, smMsg(5,  "test_5-1-4-b", "rc2int didn't convert 0,1 to 1"))
    PICOTEST_VERIFY(rc2int(0,2) == 2, smMsg(5,  "test_5-1-4-b", "rc2int didn't convert 0,2 to 2"))
    PICOTEST_VERIFY(rc2int(1,0) == 10, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 1,0 to 10"))
    PICOTEST_VERIFY(rc2int(1,1) == 11, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 1,1 to 11"))
    PICOTEST_VERIFY(rc2int(1,2) == 12, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 1,2 to 12"))
    PICOTEST_VERIFY(rc2int(2,0) == 20, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 2,0 to 20"))
    PICOTEST_VERIFY(rc2int(2,1) == 21, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 2,1 to 21"))
    PICOTEST_VERIFY(rc2int(2,2) == 22, smMsg(5,  "test_5-1-4-c", "rc2int didn't convert 2,2 to 22"))
    PICOTEST_VERIFY(rc2int(-1,1) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert -1,1 to -1"))
    PICOTEST_VERIFY(rc2int(-1,-1) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert -1,-1 to -1"))
    PICOTEST_VERIFY(rc2int(1,-1) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert 1,-1 to -1"))
    PICOTEST_VERIFY(rc2int(3,1) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert 3,1 to -1"))
    PICOTEST_VERIFY(rc2int(3,3) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert 3,3 to -1"))
    PICOTEST_VERIFY(rc2int(1,3) == -1, smMsg(5,  "test_5-1-4-d", "rc2int didn't convert 1,3 to -1"))
}

PICOTEST_CASE(MOVEnWIN) {
    PICOTEST_VERIFY(winningMove(emptyB)==-1 , smMsg(5,  "test_5-1-5-a", "Found winning move at empty board or considered it as bad!"))
    PICOTEST_VERIFY(winningMove(finishedB1)==-2 , smMsg(5,  "test_5-1-5-b", "Found winning move at finished board (XXX|OOX|OOX)!"))
    PICOTEST_VERIFY(winningMove(finishedB2bad)==-2 , smMsg(5,  "test_5-1-5-c", "Found winning move at finished bad board (XXX|OOX|XOX)!"))
    PICOTEST_VERIFY(winningMove(finishedB3bad)==-2 , smMsg(5,  "test_5-1-5-c", "Found winning move at finished bad board! (XXO|OOX|OOX)"))
    PICOTEST_VERIFY(winningMove(NOTfinishedB4bad) == -2, smMsg(5,  "test_5-1-5-d", "Found winning move at unfinished bad board! (XX-|O-X|-OX)"))
    PICOTEST_VERIFY(winningMove(NOTfinishedB5bad)==-2 , smMsg(5,  "test_5-1-5-d", "Found winning move at unfinished bad board (XX-|--X|-OX)"))
    PICOTEST_VERIFY(winningMove(NOTfinishedB6bad)==-2 , smMsg(5,  "test_5-1-5-d", "Found winning move at unfinished bad board (XO-|--O|-OX)"))
    PICOTEST_VERIFY(winningMove(unfinishedB7playsX)==-1 , smMsg(5,  "test_5-1-5-e", "Found winning move at unfinished early game board! (O--|-X-|---) or considered it as bad!"))
    PICOTEST_VERIFY(winningMove(unfinishedB8playsO)==-1 , smMsg(5,  "test_5-1-5-e", "Found winning move at unfinished board! (O--|-X-|X--) or considered it as bad!"))
    PICOTEST_VERIFY(winningMove(brokenB9)==-2 , smMsg(5,  "test_5-1-5-f", "Found winning move at bad board! (XO-|-3X|-OX)"))
    PICOTEST_VERIFY(winningMove(playNwinXat00B10)==0 , smMsg(5,  "test_5-1-5-g", "NOT Found winning move of X at unfinished board! (-XX|-OO|---)"))
    PICOTEST_VERIFY(winningMove(playNwinOat10B11)==10 , smMsg(5,  "test_5-1-5-g", "NOT Found winning move of O at unfinished board! (-XX|-OO|--X)"))
    PICOTEST_VERIFY(winningMove(playNwinOat22B12)==22 , smMsg(5,  "test_5-1-5-g", "NOT Found winning move of O at unfinished board! (OXO|-OX|XX-)"))
    PICOTEST_VERIFY(checkBoard2be(playNwinXat00B10, "-XX|-OO|---") , smMsg(5,  "test_5-1-5-h", "Board altered while finding winning move of unfinished board! (-XX|-OO|---)"))
    PICOTEST_VERIFY(checkBoard2be(playNwinOat10B11, "-XX|-OO|--X") , smMsg(5,  "test_5-1-5-h", "Board altered while finding winning move of unfinished board! (-XX|-OO|--X)"))
    PICOTEST_VERIFY(checkBoard2be(playNwinOat22B12, "OXO|-OX|XX-") , smMsg(5,  "test_5-1-5-h", "Board altered while finding winning move of unfinished board! (OXO|-OX|XX-)"))
    PICOTEST_VERIFY(checkBoard2be(playNwinOat22B12, "OXO|-OX|XX-") , smMsg(5,  "test_5-1-5-i", "Board altered while finding winning move of unfinished board! (OXO|-OX|XX-)"))
}
