#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

bool titleCase(char *text);

PICOTEST_SUITE(mainSuite, SANITI_TESTS)
PICOTEST_CASE(SANITI_TESTS) {
    bool res;
    char t1[] = "singleword";
    char t2[] = "Singleword";
    char t3[] = "SINGLEWORD";
    char t4[] = "          ";
    char t5[] = "two words";
    char t6[] = "Two Words";
    char t7[] = " - Some times I say...";
    char t8[] = " - And then, i reply!";
    char t9[] = "Bilingual? No! Multilingual? Maybe... Unilingual? Suuuuuure!";
    char t10[] = "!@#$%^&*()";
    char t11[] = "a b c d e f g h";
    char t12[] = "A B C D E F G H";

    PICOTEST_VERIFY(!titleCase(NULL), smMsg(7, "test_7-2-1-a", "Failed to detect a NULL input"));
    PICOTEST_VERIFY( titleCase(t1) && strcmp(t1, "Singleword")==0, smMsg(7, "test_7-2-1-b", "Failed to convert the single word t1=%s", t1));
    PICOTEST_VERIFY(!titleCase(t2) && strcmp(t2, "Singleword")==0, smMsg(7, "test_7-2-1-c", "Failed to convert the single word t2=%s", t2));
    PICOTEST_VERIFY( titleCase(t3) && strcmp(t3, "Singleword")==0, smMsg(7, "test_7-2-1-b", "Failed to convert the single word t3=%s", t3));
    PICOTEST_VERIFY(!titleCase(t4) && strcmp(t4, "          ")==0, smMsg(7, "test_7-2-1-d", "Failed to convert an all space text t4=%s", t4));
    PICOTEST_VERIFY( titleCase(t5) && strcmp(t5, "Two Words")==0, smMsg(7, "test_7-2-1-b", "Failed to convert an all space text t5=%s", t5));
    PICOTEST_VERIFY(!titleCase(t6) && strcmp(t6, "Two Words")==0, smMsg(7, "test_7-2-1-c", "Failed to convert an all space text t6=%s", t6));
    PICOTEST_VERIFY( titleCase(t7) && strcmp(t7, " - Some Times I Say...")==0, smMsg(7, "test_7-2-1-e", "Failed to convert a mixed text t7=%s", t7));
    PICOTEST_VERIFY( titleCase(t8) && strcmp(t8, " - And Then, I Reply!")==0, smMsg(7, "test_7-2-1-e", "Failed to convert a mixed text t8=%s", t8));
    PICOTEST_VERIFY(!titleCase(t9) && strcmp(t9, "Bilingual? No! Multilingual? Maybe... Unilingual? Suuuuuure!")==0, smMsg(7, "test_7-2-1-f", "Failed to convert a mixed text t9=%s", t9));
    PICOTEST_VERIFY(!titleCase(t10) && strcmp(t10, "!@#$%^&*()")==0, smMsg(7, "test_7-2-1-d", "Failed to convert a mixed text t10=%s", t10));
    PICOTEST_VERIFY( titleCase(t11) && strcmp(t11, "A B C D E F G H")==0, smMsg(7, "test_7-2-1-b", "Failed to convert alphabet t11=%s", t11));
    PICOTEST_VERIFY(!titleCase(t12) && strcmp(t12, "A B C D E F G H")==0, smMsg(7, "test_7-2-1-c", "Failed to convert alphabet t12=%s", t12));
}


//PICOTEST_SUITE(mainSuite, RANGE_TESTS, BOUNDARY_TESTS)
//
//PICOTEST_CASE(RANGE_TESTS) {
//    int v5in1_2 = !isInRange(5, 1, 2);
//    PICOTEST_VERIFY(v5in1_2, "isInRange(5,1,2) returns unexpected result!");
//    int v5in1_8 = isInRange(5, 1, 8);
//    PICOTEST_VERIFY(v5in1_8, "isInRange(5,1,8) returns unexpected result!");
//}
//PICOTEST_CASE(BOUNDARY_TESTS) {
//    int v5in1_5 = isInRange(5,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(5,1,5) returns unexpected result!");
//    int v1in1_5 = isInRange(1,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(1,1,5) returns unexpected result!");
//}
//PICOTEST_CASE(aktina_0) {
//}
//PICOTEST_CASE(aktina_PI) {
//}
