#include <stdbool.h>
#include <stdlib.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

bool checkSuperString(SuperString *ss, int base, int size, char *txt) {
    bool res = !(ss == NULL ||
                 base != ss->baseSize ||
                 size != ss->size ||
                 strcmp(ss->text, txt) != 0);
    if (ss != NULL) {
        if (ss->text != NULL) {
            free(ss->text);
        }
        free(ss);
    }
    return res;
}

PICOTEST_SUITE(mainSuite, CREATE_TESTS, APPEND_TESTS, TRUNCATE_TESTS)

PICOTEST_CASE(CREATE_TESTS) {
    printf(" ========================\n");
    PICOTEST_VERIFY(ssCreate(-1, "test") == NULL, smMsg('B', "test_b-1-1-a", "Failed to verify negative base-size.\n"));
    PICOTEST_VERIFY(ssCreate(0, "tost") == NULL, smMsg('B', "test_b-1-1-a", "Failed to verify 0 base-size\n"));
    PICOTEST_VERIFY(ssCreate(1, "yrdy") == NULL, smMsg('B', "test_b-1-1-a", "Failed to verify 1 base-size - 1 is meaningless as base-size\n"));
    PICOTEST_VERIFY(ssCreate(5, NULL) == NULL, smMsg('B', "test_b-1-1-a", "Failed to verify NULL string given\n"));

    int s = 5, size, base;
    char *text;
    printf("\n\nFor tests below (up to APPEND_TESTS): s = %d\n", s);
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = s, text = ""), smMsg('B', "test_b-1-1-b", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = s, text = "aa"), smMsg('B', "test_b-1-1-c", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = 2 * s, text = "abcd"), smMsg('B', "test_b-1-1-d", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = 3 * s, text = "abcdedcba"), smMsg('B', "test_b-1-1-d", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = 2 * s, text = "abcde"), smMsg('B', "test_b-1-1-e", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = 2 * s, text = "abcdefgh"), smMsg('B', "test_b-1-1-e", "Failed to verify for s=%d\n", s));
    PICOTEST_VERIFY(checkSuperString(ssCreate(s, text), base = s, size = 3 * s, text = "abcdefghi"), smMsg('B', "test_b-1-1-e", "Failed to verify for s=%d\n", s));
    printf("\n                             ");
}



//PICOTEST_CASE(DELETE_TESTS) {
//    int base;
//    char *text;
//    PICOTEST_VERIFY(checkDeleteSS("testing", base=5), "Failed to free internally created SuperString\n");
//    PICOTEST_VERIFY(checkDeleteSS("testing", base=25), "Failed to free internally created SuperString\n");
//    PICOTEST_VERIFY(checkDeleteSS(NULL, base=5), "Failed to free internally created SuperString\n");
//}

bool compareSuperStrings(SuperString *s1, SuperString *s2) {
    if (s1 == NULL || s2 == NULL) {
        return s1 == s2;
    }
    bool res = (strcmp(s1->text, s2->text) == 0 &&
                s1->size == s2->size &&
                s1->baseSize == s2->baseSize);
    return res;
}

char *joinTexts(char *t1, char *t2) {
    int l1 = strlen(t1);
    int l2 = strlen(t2);
    char *r = (char *) malloc(l1 + l2 + 1);
    strcpy(r, t1);
    strcat(r, t2);
    return r;
}

PICOTEST_CASE(APPEND_TESTS) {
    printf(" ========================\n\nFOLLOWING RESULTS ARE VALID ONLY IF ssCreate TESTS PASS OK\n\n");
    char *T1, *T2;
    SuperString *s1, *s2;
    int size;

    PICOTEST_VERIFY(ssAppend(s1 = ssCreate(size=50, T1 = "Hello "), NULL) == false, smMsg('B', "test_b-1-3-a", "Append of NULL string, C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(ssAppend(NULL, "Hi there!") == false, smMsg('B', "test_b-1-3-a", "Append to NULL SuperString, C H E C K   F A I L E D!\n"))

    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=50, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-b", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=14, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-c", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=13, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-d", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=12, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-e", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=11, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-e", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=5, T1 = "Hello "), T2 = "there!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-e", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=5, T1 = "Hello there "), T2 = "kids!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-e", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(
            ssAppend(s1 = ssCreate(size=5, T1 = "Hi "), T2 = "to all the students!") &&
            (s2 = ssCreate(size, joinTexts(T1,T2))) && compareSuperStrings(s1, s2)
            , smMsg('B', "test_b-1-3-e", "C H E C K   F A I L E D!\n"))
    printf("\n                             ");
}


PICOTEST_CASE(TRUNCATE_TESTS) {
    SuperString *s;
    PICOTEST_VERIFY(ssTruncate(NULL) == false, smMsg('B', "test_b-1-4-a", "Truncate of NULL SuperString, C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(ssTruncate(s = ssCreate(50, "test")) && s->size == strlen(s->text)+1, smMsg('B', "test_b-1-4-b", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(ssTruncate(s = ssCreate(5, "test")) && s->size == strlen(s->text)+1, smMsg('B', "test_b-1-4-c", "C H E C K   F A I L E D!\n"))
    PICOTEST_VERIFY(ssTruncate(s = ssCreate(5, "testing text with letters")) && s->size == strlen(s->text)+1, smMsg('B', "test_b-1-4-d", "C H E C K   F A I L E D!\n"))
    printf("\n                             ");
}
