// smProject - S T A R T   O F   C O D E
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include "libs/library.h"
#include <malloc.h>

typedef struct _super_string {
    char *text;     // Ο χώρος ο οποίος περιέχει το κείμενο και συνήθως κάποια πρόσθετα bytes
    int size;       // To μέγεθος του χώρου που περιέχει το κείμενο - ΌΧΙ το μήκος του κειμένου
    int baseSize;   // Το βασικό μέγεθος, πολλαπλάσιο του οποίου είναι το size, με εξαίρεση την
    // περίπτωση που έχει προηγηθεί η ssTruncate
} SuperString;

SuperString *ssCreate(int base, char *string);

bool ssAppend(SuperString *ss, char *string);

bool ssTruncate(SuperString *ss);

void ssDelete(SuperString *ss);

/**
 * Δημιουργεί ένα SuperString βάσει των παραμέτρων.
 * Ως constructor, εάν δεν έχουν νόημα οι παράμετροι,
 * θα πρέπει να επιστρέφεται NULL ως ένδειξη λάθους.
 * Εξυπακούεται ότι το κείμενο που δίνεται θα πρέπει
 * να αντιγράφεται σε καινούριο χώρο στο SuperString,
 * αλλιώς δεν θα μπορείτε να υλοποιήσετε τα ζητούμενα
 * της άσκησης.
 * @param base - Το βασικό μέγεθος για αυτό το SuperString. Πρέπει να είναι τουλάχιστον 2.
 * @param string - Το αρχικό περιεχόμενο του SuperString.
 * @return Το SuperString ή NULL εάν υπάρχει πρόβλημα.
 */
SuperString *ssCreate(int base, char *string) {

}

/**
 * Η συνάρτηση "καταστρέφει" (destructor) το Super String και
 * απελευθερώνει τα σχετικά resources (μνήμη).
 * @param ss Ο δείκτης στη δομή που πρόκειται να απελευθερωθεί.
 */
void ssDelete(SuperString *ss) {

}

/**
 * Η συνάρτηση αυτή περικόπτει τη δεσμευμένη μνήμη για το κείμενο
 * στο απολύτως απαραίτητο μέγεθος. Οπότε σε αυτή την περίπτωση,
 * μετά την κλήση της συνάρτησης, το δεσμευμένο μέγεθος δεν αποτελεί
 * πολλαπλάσιο του βασικού μεγέθους.
 *
 * Εάν όλα ολοκληρωθούν επιτυχώς τότε επιστρέφει αληθές, αλλιώς ψευδές.
 *
 * @param ss Το Super String που θα περικοπεί
 * @return Επιστρέφει true ή false
 */
bool ssTruncate(SuperString *ss) {

}

/**
 * Προσαρτά το νέο κείμενο string στο τέλος του SuperString
 * κατά τον τρόπο που το κάνει και η strcat. Προσέξτε όμως
 * να υπάρχει αρκετός χώρος και όταν δεν υπάρχει να εξασφαλίζεται
 * αλλά και την απαίτηση το size να είναι πολλαπλάσιο του
 * βασικού μεγέθους base size.
 *
 * Σε περίπτωση που δεν υπάρχει η δυνατότητα θα πρέπει να
 * επιστρέφει ψευδές και το αρχικό κείμενο θα πρέπει να μην
 * επιρρεάζεται.
 *
 * @param ss Το ίδιο το SuperString
 * @param string Το κείμενο που θα προσαρτηθεί, εάν είναι NULL
 * η προσάρτηση είναι αδύνατη.
 * @return Αληθές (true) εάν όλα πήγαν καλά.
 */
bool ssAppend(SuperString *ss, char *string) {

}


int smMain(int c, smString v[]) {
    printf("Hello engineers!\n");

    SuperString *ss = ssCreate(10, "");
    ssAppend(ss, "Test A,B,C...");
    printf("BOOL TRUNCATE : %i\n", ssTruncate(ss));
    ssDelete(ss);

    return 0;
}
// smProject - E N D   O F   C O D E
