// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

int arr1[] = { 8 };
int arr3[] = { 8, 5, 3 };
int arr8[] = { 1, 2, 3, 4, 5, 6, 7, 8 };

bool testRotateArray(int A[], int N, int k, bool toRight) {
    int H[2*N], B[N];
    for (int i = 0; i < 2 * N; ++i) {
        H[i] = A[i%N];
    }
    for (int i = 0; i < N; ++i) {
        B[i] = A[i];
    }
//    printf("GET IN!\n");
    bool result = rotateArray(B,N,k,toRight);
//    printf("GET OUT!\n");
    bool shouldReturn = (k>=0 && N>0);
    if (result != shouldReturn) { return false; }
    if (shouldReturn == false) { return true; }
    k %= N;
    bool isOk = true;
    if (toRight) {
        for (int i = 0; i < N; ++i) {
            if (B[i] != H[N-k+i]) {
                isOk=false;
                break;
            }
        }
        if (!isOk) {
            printf("\nBRHKATE: ");
            for (int i = 0; i < N; ++i) {
                printf("%d ", B[i]);
            }
            printf("\n  SWSTO: ");
            for (int i = 0; i < N; ++i) {
                printf("%d ", H[N-k+i]);
            }
            printf("\n");
            return false;
        }
    } else {
        for (int i = 0; i < N; ++i) {
            if (B[i] != H[k+i]) {
                isOk=false;
                break;
            }
        }
        if (!isOk) {
            printf("\nBRHKATE: ");
            for (int i = 0; i < N; ++i) {
                printf("%d ", B[i]);
            }
            printf("\n  SWSTO: ");
            for (int i = 0; i < N; ++i) {
                printf("%d ", H[k+i]);
            }
            printf("\n");
            return false;
        }
    }
    return true;
}

PICOTEST_SUITE(mainSuite, SANITY_TESTS, SIMPLE_TESTS, EXTRA_TESTS)
PICOTEST_CASE(SANITY_TESTS) {
    PICOTEST_VERIFY(testRotateArray(arr1, 0, 1, true), smMsg(5,  "test_5-2-1-a", "Rotated right array of N=0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, -1, 1, true), smMsg(5,  "test_5-2-1-b", "Rotated right array of negative length !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, -1, true), smMsg(5,  "test_5-2-1-c", "Rotated right array of negative positions !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 0, 1, false), smMsg(5,  "test_5-2-1-a", "Rotated left array of N=0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, -1, 1, false), smMsg(5,  "test_5-2-1-b", "Rotated left array of negative length !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, -1, false), smMsg(5,  "test_5-2-1-c", "Rotated left array of negative positions !!!"))
}
PICOTEST_CASE(SIMPLE_TESTS) {
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 0, true), smMsg(5,  "test_5-2-2-a", "Rotated right array of N=1 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 0, true), smMsg(5,  "test_5-2-2-a", "Rotated right array of N=3 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 1, true), smMsg(5,  "test_5-2-2-b", "Rotated right array of N=3 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 2, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=3 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 0, true), smMsg(5,  "test_5-2-2-a", "Rotated right array of N=8 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 1, true), smMsg(5,  "test_5-2-2-b", "Rotated right array of N=8 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 2, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 3, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 3 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 4, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 4 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 5, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 5 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 6, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 6 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 7, true), smMsg(5,  "test_5-2-2-c", "Rotated right array of N=8 by 7 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 0, false), smMsg(5,  "test_5-2-2-d", "Rotated left array of N=1 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 0, false), smMsg(5,  "test_5-2-2-d", "Rotated left array of N=3 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 1, false), smMsg(5,  "test_5-2-2-e", "Rotated left array of N=3 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 2, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=3 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 0, false), smMsg(5,  "test_5-2-2-d", "Rotated left array of N=8 by 0 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 1, false), smMsg(5,  "test_5-2-2-e", "Rotated left array of N=8 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 2, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 3, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 3 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 4, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 4 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 5, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 5 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 6, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 6 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 7, false), smMsg(5,  "test_5-2-2-f", "Rotated left array of N=8 by 7 !!!"))
}
PICOTEST_CASE(EXTRA_TESTS) {
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 1, true), smMsg(5,  "test_5-2-3-a", "Rotated right array of N=1 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 2, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=1 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 3, true), smMsg(5,  "test_5-2-3-c", "Rotated right array of N=3 by 3 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 4, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=3 by 4 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 5, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=3 by 5 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 8, true), smMsg(5,  "test_5-2-3-c", "Rotated right array of N=8 by 8 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 9, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 9 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 10, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 10 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 11, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 11 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 12, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 12 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 13, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 13 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 14, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 14 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 15, true), smMsg(5,  "test_5-2-3-b", "Rotated right array of N=8 by 15 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 1, false), smMsg(5,  "test_5-2-3-d", "Rotated left array of N=1 by 1 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 1, 2, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=1 by 2 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 3, false), smMsg(5,  "test_5-2-3-f", "Rotated left array of N=3 by 3 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 4, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=3 by 4 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr3, 3, 5, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=3 by 5 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 8, false), smMsg(5,  "test_5-2-3-f", "Rotated left array of N=8 by 8 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 9, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 9 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 10, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 10 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 11, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 11 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 12, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 12 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 13, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 13 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 14, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 14 !!!"))
    PICOTEST_VERIFY(testRotateArray(arr1, 8, 15, false), smMsg(5,  "test_5-2-3-e", "Rotated left array of N=8 by 15 !!!"))
}
