#include <stdlib.h>
#include <stdbool.h>
#include <time.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

double minOfList(Node *firstNode);

double tyxaios(double a, double b) {
    return (rand()*(b-a)/RAND_MAX) + a;
}

Node *createRandomNode(double a, double b) {
    Node *node = malloc(sizeof(Node));
    node->data = tyxaios(a,b);
    node->nextNode = NULL;
}

Node *createSequence(int N, double a, double b) {
    Node *first = createRandomNode(a,b);
    Node *current = first;
    for (int i = 1; i < N; ++i) {
        current->nextNode = createRandomNode(a,b);
        current = current->nextNode;
    }
    return first;
}

void setNth2Value(int N, double value, Node *list) {
    for (int i = 0; i < N && list != NULL; ++i) {
        if (i == N-1) {
            list->data = value;
            return;
        }
        list = list->nextNode;
    }
}

int printList(Node *list) {
    printf("\n\n");
    while (list != NULL) {
        printf("%lg ", list->data);
        list = list->nextNode;
    }
//    printf("\n");
    return '!';
}

PICOTEST_SUITE(mainSuite, COMPLETE_TESTS)
PICOTEST_CASE(COMPLETE_TESTS) {
    srand(time(0));
    Node *aList;
    double minValue = 1.99;
    aList = createSequence(11,8,8);
    PICOTEST_VERIFY(1e30 == minOfList(NULL), smMsg('C', "test_c-1-1-a", "Failed to verify EMPTY list above %c", printList(NULL)));
    aList = createSequence(1,8,8);
    PICOTEST_VERIFY(minOfList(aList) == 8, smMsg('C', "test_c-1-1-b", "Failed to verify a single-item positive list above %c", printList(aList)));
    aList = createSequence(10,2,10);
    setNth2Value(1, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a first-is-min positive list above %c", printList(aList)));
    aList = createSequence(10,2,10);
    setNth2Value(2, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a second-is-min positive list above %c", printList(aList)));
    aList = createSequence(16,2,10);
    setNth2Value(8, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify an intermediate-is-min positive list above %c", printList(aList)));
    aList = createSequence(10,2,10);
    setNth2Value(9, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a penultimate-is-min positive list above %c", printList(aList)));
    aList = createSequence(10,2,10);
    setNth2Value(10, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a last-is-min positive list above %c", printList(aList)));
    minValue = -0.1;
    aList = createSequence(10,2,10);
    setNth2Value(6, 0, aList);
    setNth2Value(7, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a just-after-zero positive list above %c", printList(aList)));
    aList = createSequence(10,2,10);
    setNth2Value(8, 0, aList);
    setNth2Value(7, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a just-before-zero positive list above %c", printList(aList)));
    aList = createSequence(1,-8,-8);
    PICOTEST_VERIFY(minOfList(aList) == -8, smMsg('C', "test_c-1-1-b", "Failed to verify a single-item negative list above %c", printList(aList)));
    minValue = -10.01;
    aList = createSequence(10,-2,-10);
    setNth2Value(1, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a first-is-min negative list above %c", printList(aList)));
    aList = createSequence(10,-2,-10);
    setNth2Value(2, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a second-is-min negative list above %c", printList(aList)));
    aList = createSequence(16,-2,-10);
    setNth2Value(8, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify an intermediate-is-min negative list above %c", printList(aList)));
    aList = createSequence(10,-2,-10);
    setNth2Value(9, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a penultimate-is-min negative list above %c", printList(aList)));
    aList = createSequence(10,-2,-10);
    setNth2Value(10, minValue, aList);
    PICOTEST_VERIFY(minOfList(aList) == minValue, smMsg('C', "test_c-1-1-b", "Failed to verify a last-is-min negative list above %c", printList(aList)));
}
