#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

PICOTEST_SUITE(mainSuite, ALL_TESTS)

Matrix * mtrxAdd(Matrix *A, Matrix *B);
Matrix * mtrxMul(Matrix *A, Matrix *B);

PICOTEST_CASE(ALL_TESTS) {
    Matrix *v1to5 = mtrxCreateZero(5,1);
    v1to5->cells[0][0] = 1.0;
    v1to5->cells[1][0] = 2.0;
    v1to5->cells[2][0] = 3.0;
    v1to5->cells[3][0] = 4.0;
    v1to5->cells[4][0] = 5.0;
    Matrix *h1to5 = mtrxCreateZero(1,5);
    h1to5->cells[0][0] = 1.0;
    h1to5->cells[0][1] = 2.0;
    h1to5->cells[0][2] = 3.0;
    h1to5->cells[0][3] = 4.0;
    h1to5->cells[0][4] = 5.0;
    Matrix *z1by5 = mtrxCreateZero(1,5);
    Matrix *z5by1 = mtrxCreateZero(5,1);


    PICOTEST_VERIFY(mtrxAdd(NULL,NULL) == NULL, smMsg(8, "test_8-1-1-a", "Sum of NULL and NULL"));
    PICOTEST_VERIFY(mtrxAdd(v1to5,NULL) == NULL, smMsg(8, "test_8-1-1-a", "Sum of NULL and NON-NULL"));
    PICOTEST_VERIFY(mtrxAdd(NULL,v1to5) == NULL, smMsg(8, "test_8-1-1-a", "Sum of NON-NULL and NULL"));
    PICOTEST_VERIFY(mtrxAdd(h1to5,v1to5) == NULL, smMsg(8, "test_8-1-1-b", "Sum of incompatible sized matrix"));
    PICOTEST_VERIFY(mtrxMul(NULL,NULL) == NULL, smMsg(8, "test_8-1-1-a", "Product of NULL and NULL"));
    PICOTEST_VERIFY(mtrxMul(v1to5,NULL) == NULL, smMsg(8, "test_8-1-1-a", "Product of NULL and NON-NULL"));
    PICOTEST_VERIFY(mtrxMul(NULL,v1to5) == NULL, smMsg(8, "test_8-1-1-a", "Product of NON-NULL and NULL"));
    PICOTEST_VERIFY(mtrxMul(h1to5,h1to5) == NULL, smMsg(8, "test_8-1-1-b", "Product of incompatible sized matrix"));

    Matrix* h1to5check = mtrxAdd(h1to5,z1by5);
    bool check = (h1to5check != NULL);
    for (int i = 0; i < 5; ++i) {
        check = check && (h1to5check->cells[0][i] == h1to5->cells[0][i]);
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-c", "Sum of 5x1 matrix and zero matrix failed"));
    Matrix* v1to5x2 = mtrxAdd(v1to5,v1to5);

    check = (v1to5x2 != NULL);
    for (int i = 0; i < 5; ++i) {
        check = check && (v1to5x2->cells[i][0] == 2*v1to5->cells[i][0]);
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-c", "Sum of 5x1 matrix and it self failed"));

    Matrix* r1x1 = mtrxMul(h1to5,v1to5);
    check = (r1x1 != NULL);
    check = check && (r1x1->rows == 1) && (r1x1->cols == 1);
    check = check && (r1x1->cells[0][0] == 55.0);
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-d", "Product of 1x5 and 5x1 (to 1x1) matrix check failed"));

    Matrix* r5x5 = mtrxMul(v1to5,h1to5);
    check = (r5x5 != NULL);
    check = check && (r5x5->rows == 5) && (r5x5->cols == 5);
    for (int i = 0; i < 5; ++i) {
        for (int j = 0; j < 5; ++j) {
            check = check && (r5x5->cells[i][j] == (i+1)*(j+1));
        }
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-e", "Product of 5x1 and 1x5 (to 5x5) matrix check failed"));

    Matrix *i5x5 = mtrxCreateI(5);
    Matrix *rs5x5 = mtrxAdd(r5x5, i5x5);
    check = (rs5x5 != NULL);
    check = check && (rs5x5->rows == 5) && (rs5x5->cols == 5);
    for (int i = 0; i < 5; ++i) {
        for (int j = 0; j < 5; ++j) {
            check = check && (rs5x5->cells[i][j] == ((i+1)*(j+1) + ((i==j)?1:0)));
        }
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-g", "Combinatory Sum of 5x5 (product result) and I (5x5) matrix check failed"));

    Matrix *rp5x5 = mtrxMul(r5x5, i5x5);
    check = (rp5x5 != NULL);
    check = check && (rp5x5->rows == 5) && (rp5x5->cols == 5);
    for (int i = 0; i < 5; ++i) {
        for (int j = 0; j < 5; ++j) {
            check = check && (rp5x5->cells[i][j] == r5x5->cells[i][j]);
        }
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-f", "Prod of 5x5 and I (5x5) matrix check failed"));

    Matrix *rsq5x5 = mtrxMul(r5x5, r5x5);
    check = (rsq5x5 != NULL);
    check = check && (rsq5x5->rows == 5) && (rsq5x5->cols == 5);
    check = check && (rsq5x5->cells[0][0] == 55.0);
    for (int i = 0; i < 5; ++i) {
        check = check && (rsq5x5->cells[i][0] == (i+1)*rsq5x5->cells[0][0]);
        for (int j = 0; j < 5; ++j) {
            check = check && (rsq5x5->cells[i][j] == ((j+1)*rsq5x5->cells[i][0]));
        }
    }
    PICOTEST_VERIFY(check, smMsg(8, "test_8-1-1-f", "Prod of 5x5 and I (5x5) matrix check failed"));
}
