// smProject - S T A R T   O F   C O D E
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include "libs/library.h"

/**
 * Η δομή αυτή περιγράφει έναν αλγεβρικό πίνακα
 * Έχει το πλήθος των γραμμών του (rows),
 * το πλήθος των στηλών του (cols) και
 * τα δεδομένα του (cells) που αντιστοιχούν σε
 * πίνακα double δύο διαστάσεων
 */
typedef struct _matrix {
    unsigned int rows;
    unsigned int cols;
    double **cells;
} Matrix;

/**
 * Διαγραφή του πίνακα matrix και απελευθέρωση όλων
 * των σχετικών πόρων (γραμμές, εσωτερικός πίνακας στήλη, δομή)
 * Δείτε ότι η απελευθέρωση γίνεται με την αντίθετη σειρά από
 * αυτή της δέσμευσης στον constructor
 * @param M - ο πίνακας που θα διαγραφεί
 */
void mtrxDeleteMatrix(Matrix *M) {
    if (M == NULL) {
        return;
    }

    // εφόσον υπάρχει "κατακόρυφος" πίνακας γραμμών
    if (M->cells != NULL) {
        // απελευθερώνω μία προς μία όλες τις γραμμές
        for (int i = 0; i < M->rows; ++i) {
            // εφόσον όντως είχα pointer σε αυτές
            if (M->cells[i] != NULL) {
                free(M->cells[i]);
            }
        }
        // ΜΕΤΑ απελευθερώνω τον "κατακόρυφο" πίνακα
        free(M->cells);
    }
    // ΤΕΛΟΣ απελευθερώνω την ίδια τη δομή
    free(M);
    // εδώ δεν χρειάζεται return αφού η συνάρτηση είναι void
}

/**
 * Δημιουργεί έναν αλγεβρικό πίνακα r x c με μηδενικά στοιχεία
 * @param r - οι γραμμές
 * @param c - οι στήλες
 * @return - pointer στον αλγεβρικό πίνακα (= στη δομή που τον περιγράφει)
 */
Matrix *mtrxCreateZero(int r, int c) {
    // Ελέγχω τις παραμέτρους
    if (r <= 0 || c <= 0) {
        return NULL;
    }

    // Βρίσκω μνήμη για τη δομή του Matrix
    Matrix *M = (Matrix *) malloc(sizeof(Matrix));
    // Αν δεν υπάρχει επιστρέφω NULL
    if (M == NULL) {
        return NULL;
    }

    // Δινώ τιμές στα πεδία
    M->rows = r;
    M->cols = c;
    M->cells = (double **) malloc(M->rows * sizeof(double *));
    if (M->cells == NULL) {
        // αν δεν υπάρχει μνήμη, απελευθερώνω με τη χρήση της delete τους πόρους
        mtrxDeleteMatrix(M);
        return NULL;
    }

    // κάνω NULL τα στοιχεία πριν από την 1η τους χρήση, ώστε μέσα στην delete να ξέρω αν
    // έχει γίνει malloc η κάθε γραμμή ή όχι - βλέπε σημείωση και στο επόμενο loop
    for (int i = 0; i < M->rows; ++i) {
        M->cells[i] = NULL;
    }

    // για κάθε γραμμή ...
    for (int i = 0; i < M->rows; ++i) {
        // (a) ζητάω την απαιτούμενη μνήμη
        M->cells[i] = (double *) malloc(M->cols * sizeof(double));
        // (β) ελέγχω μήπως δεν υπάρχει διαθέσιμη
        if (M->cells[i] == NULL) {
            // αν δεν υπάρχει αρκετή μνήμη απελεθερώνω τους πόρους με χρήση της delete
            // σημειώστε ότι όλοι οι υπόλοιποι pointers στις υπόλοιπες γραμμές είναι
            // ήδη NULL λόγω του προηγούμενου loop
            mtrxDeleteMatrix(M);
            return NULL;
        }
        // εάν όλα πάνε καλά μηδενίζω τα στοιχεία της γραμμής, αφού το ζητούμενο είναι ο Μηδενικός πίνακας
        for (int j = 0; j < M->cols; ++j) {
            M->cells[i][j] = 0.0;
        }
    }

    // επιστρέφω τον πίνακα (δηλαδή τον pointer στη δομή που τον περιγράφει)
    return M;
}

/**
 * Δημιουργία Μοναδιαίου πίνακα I
 * @param size - Το μέγεθος του πίνακα Ι θα είναι size x size
 * @return
 */
Matrix *mtrxCreateI(int size) {
    // Δημιουργία - αξιοποιώ τον προηγούμενο constructor - ο οποίος κάνει και τους σχετικούς ελέγχους
    Matrix *M = mtrxCreateZero(size, size);
    // Ελέγχω αν όλα πήγαν καλά
    if (M == NULL) {
        return NULL;
    }

    // Δίνω τιμές 1 στη διαγώνιο
    for (int i = 0; i < size; ++i) {
        M->cells[i][i] = 1.0;
    }

    // Επιστρέφω τον πίνακα
    return M;
}

/**
 * Εκτυπώνει τον πίνακα matrix
 * @param matrix
 */
void mtrxPrint(Matrix *matrix) {
    if (matrix == NULL) {
        return;
    }

    for (int i = 0; i < matrix->rows; ++i) {
        for (int j = 0; j < matrix->cols; ++j) {
            printf("%lg ", matrix->cells[i][j]);
        }
        printf("\n");
    }
}

/**
 * Προσθέτει δύο αλγεβρικούς πίνακες A και B και
 * επιστρέφει έναν νέο πίνακα ο οποίος περιέχει
 * το άρθοισμα (αν αυτό είναι δυνατόν)
 * @param A - ο ένας προσθετέος
 * @param B - ο άλλος προσθετέος
 * @return pointer στον πίνακα με το αποτέλεσμα, αν
 * είναι επιτυχής η πρόσθεση, αλλίως επιστρέφει NULL
 */
Matrix * mtrxAdd(Matrix *A, Matrix *B) {
    // todo :: Γράψτε εδώ τον κώδικά σας
}

/**
 * Πολλαπλασιάζει δύο αλγεβρικούς πίνακες A και B και
 * επιστρέφει έναν νέο πίνακα ο οποίος περιέχει
 * το γινόμενο (αν αυτό είναι δυνατόν)
 * @param A - ο πρώτος όρος του γινομένου
 * @param B - ο δεύτερος όρος του γινομένου
 * @return pointer στον πίνακα με το αποτέλεσμα, αν
 * είναι επιτυχής ο πολλαπλασιασμός, αλλίως επιστρέφει NULL
 */
Matrix * mtrxMul(Matrix *A, Matrix *B) {
    // todo :: Γράψτε εδώ τον κώδικά σας
}

int smMain(int c, smString v[]) {

    return 0;
}
// smProject - E N D   O F   C O D E