// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

#define H 12
#define W 20

PICOTEST_SUITE(mainSuite, LINE_TESTS, LIMIT_TESTS, REVERSE_TESTS)
PICOTEST_CASE(LINE_TESTS) {
    smGrid(W,H);
    drawHLine(5,3,10);
    drawVLine(15,3,10);
    drawALine(5,1,10,true);
    drawALine(1,9,18,false);
    bool **correct = smStars2Bool(12,
                                  "                    ",
                                  "     *              ",
                                  "     *              ",
                                  "     *         *    ",
                                  "     *         *    ",
                                  "   ********    *    ",
                                  "     *         *    ",
                                  "     *         *    ",
                                  "     *         *    ",
                                  " ****************** ",
                                  "     *         *    ",
                                  "                    ");
    PICOTEST_VERIFY(smTestGrid(correct), smMsg2(4, "test_4-3-1-a", -1,-1,correct, "Line test failed!"))
}
PICOTEST_CASE(LIMIT_TESTS) {
    smGrid(W,H);
    PICOTEST_VERIFY( !drawHLine(-1,2,5), smMsg(4, "test_4-3-1-b", "Horizontal with y < 0" ))
    PICOTEST_VERIFY( !drawHLine(H,2,5), smMsg(4, "test_4-3-1-b", "Horizontal with y >= H" ))
    PICOTEST_VERIFY( !drawHLine(5,-1,5), smMsg(4, "test_4-3-1-b", "Horizontal with x1 < 0" ))
    PICOTEST_VERIFY( !drawHLine(5,5,W), smMsg(4, "test_4-3-1-b", "Horizontal with x2 >= W" ))

    PICOTEST_VERIFY( !drawVLine(-1,2,5), smMsg(4, "test_4-3-1-c", "Vertical with x < 0" ))
    PICOTEST_VERIFY( !drawVLine(W,2,5), smMsg(4, "test_4-3-1-c", "Vertical with x >= W" ))
    PICOTEST_VERIFY( !drawVLine(5,-1,5), smMsg(4, "test_4-3-1-c", "Vertical with y1 < 0" ))
    PICOTEST_VERIFY( !drawVLine(5,5,H), smMsg(4, "test_4-3-1-c", "Vertical with y2 >= H" ))

    PICOTEST_VERIFY( !drawALine(-1,5,4,true), smMsg(4, "test_4-3-1-d", "Vertical ALine with x < 0" ))
    PICOTEST_VERIFY( !drawALine(-1,5,4,false), smMsg(4, "test_4-3-1-e", "Horizontal ALine with x < 0" ))
    PICOTEST_VERIFY( !drawALine(W,5,4,true), smMsg(4, "test_4-3-1-d", "Vertical ALine with x >= W" ))
    PICOTEST_VERIFY( !drawALine(W,5,4,false), smMsg(4, "test_4-3-1-e", "Horizontal ALine with x >= W" ))

    PICOTEST_VERIFY( !drawALine(5,-1,4,true), smMsg(4, "test_4-3-1-d", "Vertical ALine with y < 0" ))
    PICOTEST_VERIFY( !drawALine(5,-1,4,false), smMsg(4, "test_4-3-1-e", "Horizontal ALine with y < 0" ))
    PICOTEST_VERIFY( !drawALine(5,H,4,true), smMsg(4, "test_4-3-1-d", "Vertical ALine with y >= H" ))
    PICOTEST_VERIFY( !drawALine(5,H,4,false), smMsg(4, "test_4-3-1-e", "Horizontal ALine with y >= H" ))

    PICOTEST_VERIFY( drawALine(5,0,H,true), smMsg(4, "test_4-3-1-f", "Vertical ALine L just acceptable" ))
    PICOTEST_VERIFY( !drawALine(0,5,H+1,true), smMsg(4, "test_4-3-1-d", "Vertical ALine L just too long" ))
    PICOTEST_VERIFY( drawALine(0,0,W,false), smMsg(4, "test_4-3-1-g", "Horizontal ALine L just acceptable" ))
    PICOTEST_VERIFY( !drawALine(10,0,W+1,false), smMsg(4, "test_4-3-1-e", "Horizontal ALine L just too long" ))

    PICOTEST_VERIFY( drawALine(15,10,1,true), smMsg(4, "test_4-3-1-h", "Vertical ALine L = 1" ))
    PICOTEST_VERIFY( drawALine(15,10,1,false), smMsg(4, "test_4-3-1-h", "Horizontal ALine L = 1" ))

    PICOTEST_VERIFY( drawALine(10,10,0,true), smMsg(4, "test_4-3-1-i", "Vertical ALine L = 0" ))
    PICOTEST_VERIFY( drawALine(10,10,0,false), smMsg(4, "test_4-3-1-i", "Horizontal ALine L = 0" ))

    PICOTEST_VERIFY( !drawALine(10,5,-1,true), smMsg(4, "test_4-3-1-j", "Vertical ALine L < 0 but in bounds" ))
    PICOTEST_VERIFY( !drawALine(10,5,-1,false), smMsg(4, "test_4-3-1-j", "Horizontal ALine L < 0 but in bounds" ))

    PICOTEST_VERIFY( !drawALine(5,5,-8,true), smMsg(4, "test_4-3-1-k", "Vertical ALine L < 0 but out of bounds" ))
    PICOTEST_VERIFY( !drawALine(5,5,-8,false), smMsg(4, "test_4-3-1-k", "Horizontal ALine L < 0 but out of bounds" ))

    bool **correct = smStars2Bool(12,
                                  "********************",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *         *    ",
                                  "     *              ");

    PICOTEST_VERIFY(smTestGrid(correct), smMsg2(4, "test_4-3-1-l", -1,-1,correct, "Limit test failed!"))
//    smGrid2NamedImage("LIMITS.bmp");
}
PICOTEST_CASE(REVERSE_TESTS) {
    smGrid(W,H);
    PICOTEST_VERIFY( drawVLine(5,10,5), smMsg(4, "test_4-3-1-m", "Vertical Line reversed" ))
    PICOTEST_VERIFY( drawHLine(5,10,5), smMsg(4, "test_4-3-1-n", "Horizontal Line reversed" ))
    bool **correct = smStars2Bool(12,
                                  "                    ",
                                  "                    ",
                                  "                    ",
                                  "                    ",
                                  "                    ",
                                  "     ******         ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "     *              ",
                                  "                    ");

    PICOTEST_VERIFY(smTestGrid(correct), smMsg2(4, "test_4-3-1-o", -1,-1,correct, "Reverse test failed!"))
//    smGrid2NamedImage("REVERSE.bmp");
}