#ifndef SMLIB_LIBRARY_H
#define SMLIB_LIBRARY_H

#ifndef smEMPTY_STRING_SIZE
#define smEMPTY_STRING_SIZE 1024
#endif

#ifndef SM_MAX_STRING_BUFFER
#define SM_MAX_STRING_BUFFER 4096
#endif

#ifndef SM_MAX_STRING_BUFFER_ROWS
#define SM_MAX_STRING_BUFFER_ROWS 1024
#endif

#ifndef printf
#define printf smDoPrint
#endif

typedef char * smString;

/**
 * Αντικατάσταση της main για τις ανάγκες του μαθήματος
 */
int smMain(int argc, char *argv[]);
int smTest(int argc, char *argv[]);

smString smNewString(int numberOfChars);

smString smReadString(smString message);

void smCleanUpBuffer();
int smDoPrint(const char *formatString, ...);
int smPrintfRows();
void smShowPrintfs();
smString smMsg(int lesson, smString ref, smString msg, ...);
smString smMsg2(int lesson, smString ref, int C, int R, bool **correct, smString msg, ...);
smString smPrintfNo(int no);
int smCharCount(char c, smString string);
bool smComparePrintfs(char *first, ...);

int smReadInt(smString message);
long smReadLong(smString message);
double smReadDouble(smString message);

bool smGrid(unsigned char W, unsigned char H);
bool smGridExists();
char *smGrid2Url();
smString smCorrect2b64(bool **correct);

bool smgSet(int c, int r, bool on);
bool smgOn(int c, int r);
bool smgOff(int c, int r);
bool smgTest(int c, int r);
bool smgToggle(int c, int r);

bool smShowGrid(bool showRuler);
bool smTestGrid(bool **correct);

void smgOpenInBrowser();
void smgOpenInBrowserCCR(bool **correct, int c, int r);
#endif //SMLIB_LIBRARY_H