#include <math.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

PICOTEST_SUITE(mainSuite, LIVE_TESTS, DEAD_TESTS)

PICOTEST_CASE(LIVE_TESTS) {
    PICOTEST_VERIFY(false == nextGen(true, -1), smMsg(3, "test_3-1-1-a", "-1 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 0), smMsg(3, "test_3-1-1-b", "0 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 1), smMsg(3, "test_3-1-1-b", "1 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(true  == nextGen(true, 2), smMsg(3, "test_3-1-1-c", "2 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(true  == nextGen(true, 3), smMsg(3, "test_3-1-1-c", "3 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 4), smMsg(3, "test_3-1-1-b", "4 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 5), smMsg(3, "test_3-1-1-b", "5 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 6), smMsg(3, "test_3-1-1-b", "6 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 7), smMsg(3, "test_3-1-1-b", "7 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 8), smMsg(3, "test_3-1-1-b", "8 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(true, 9), smMsg(3, "test_3-1-1-a", "9 neighbors returns unexpected result!"));
}
PICOTEST_CASE(DEAD_TESTS) {
    PICOTEST_VERIFY(false == nextGen(false, -1), smMsg(3, "test_3-1-1-d", "-1 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 0), smMsg(3, "test_3-1-1-e", "0 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 1), smMsg(3, "test_3-1-1-e", "1 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 2), smMsg(3, "test_3-1-1-e", "2 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(true  == nextGen(false, 3), smMsg(3, "test_3-1-1-f", "3 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 4), smMsg(3, "test_3-1-1-e", "4 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 5), smMsg(3, "test_3-1-1-e", "5 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 6), smMsg(3, "test_3-1-1-e", "6 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 7), smMsg(3, "test_3-1-1-e", "7 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 8), smMsg(3, "test_3-1-1-e", "8 neighbors returns unexpected result!"));
    PICOTEST_VERIFY(false == nextGen(false, 9), smMsg(3, "test_3-1-1-d", "9 neighbors returns unexpected result!"));
}

