#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();


bool staticBoard[12][20];
bool period2Board[12][20];
bool result12x20[12][20];
bool animatedBoard[12][20];
bool animatedBoardAfter4[12][20];
bool animatedBoardAfter8[12][20];

bool result4x5[4][5];
bool marginTests[4][5] = {
        {true,true,true,true,true},
        {true,false,false,false,true},
        {true,false,false,false,true},
        {true,true,true,true,true}
};
bool marginResult[4][5] = {
        {true,true,false,true,true},
        {true,true,false,false,true},
        {true,false,true,false,true},
        {false,true,true,true,true}
};

bool **dd2ds(int C, int R, bool data[R][C]) {
    if (!_theGrid) {
        return NULL;
    }


    bool **result = (bool **)malloc(R*sizeof(bool *));
    if (result == NULL) {
        return result;
    }

    for (int i = 0; i < R; i++) {
        result[i] = (bool *)malloc(C*sizeof(bool));

        for (int j = 0; j < C; ++j) {
            result[i][j] = data[i][j];
        }
    }

    return result;
}

bool boardInit(int rows, int cols, bool next[rows][cols]);
bool calcNextGen(int rows, int cols, bool next[rows][cols]);

bool compareBoards45(bool board1[4][5], bool board2[4][5]) {
    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < 5; ++j) {
            if (board1[i][j] != board2[i][j])
                return false;
        }
    }
    return true;
}
bool compareBoards(bool board1[12][20], bool board2[12][20]) {
    for (int i = 0; i < 12; ++i) {
        for (int j = 0; j < 20; ++j) {
            if (board1[i][j] != board2[i][j])
                return false;
        }
    }
    return true;
}

void prepareAnimatedBoard() {
    for (int r = 0; r < 12; ++r) {
        for (int c = 0; c < 20; ++c) {
            animatedBoard[r][c] = false;
            animatedBoardAfter4[r][c] = false;
            animatedBoardAfter8[r][c] = false;
        }
    }

    animatedBoard[3][2] = true;
    animatedBoard[3][3] = true;
    animatedBoard[3][4] = true;
    animatedBoard[2][4] = true;
    animatedBoard[1][3] = true;

    animatedBoardAfter4[4][3] = true;
    animatedBoardAfter4[4][4] = true;
    animatedBoardAfter4[4][5] = true;
    animatedBoardAfter4[3][5] = true;
    animatedBoardAfter4[2][4] = true;

    animatedBoardAfter8[5][4] = true;
    animatedBoardAfter8[5][5] = true;
    animatedBoardAfter8[5][6] = true;
    animatedBoardAfter8[4][6] = true;
    animatedBoardAfter8[3][5] = true;

    animatedBoard[7][8] = true;
    animatedBoard[7][9] = true;
    animatedBoard[7][10] = true;
    animatedBoard[7][11] = true;
    animatedBoard[8][11] = true;
    animatedBoard[8][7] = true;
    animatedBoard[9][11] = true;
    animatedBoard[10][7] = true;
    animatedBoard[10][10] = true;

    animatedBoardAfter4[7][2+8] = true;
    animatedBoardAfter4[7][2+9] = true;
    animatedBoardAfter4[7][2+10] = true;
    animatedBoardAfter4[7][2+11] = true;
    animatedBoardAfter4[8][2+11] = true;
    animatedBoardAfter4[8][2+7] = true;
    animatedBoardAfter4[9][2+11] = true;
    animatedBoardAfter4[10][2+7] = true;
    animatedBoardAfter4[10][2+10] = true;

    animatedBoardAfter8[7][4+8] = true;
    animatedBoardAfter8[7][4+9] = true;
    animatedBoardAfter8[7][4+10] = true;
    animatedBoardAfter8[7][4+11] = true;
    animatedBoardAfter8[8][4+11] = true;
    animatedBoardAfter8[8][4+7] = true;
    animatedBoardAfter8[9][4+11] = true;
    animatedBoardAfter8[10][4+7] = true;
    animatedBoardAfter8[10][4+10] = true;
}

void preparePeriod2Board() {
    for (int r = 0; r < 12; ++r) {
        for (int c = 0; c < 20; ++c) {
            period2Board[r][c] = false;
        }
    }

    period2Board[3][3] = true;
    period2Board[3][4] = true;
    period2Board[3][5] = true;

    period2Board[8][5] = true;
    period2Board[8][6] = true;
    period2Board[8][7] = true;
    period2Board[9][4] = true;
    period2Board[9][5] = true;
    period2Board[9][6] = true;

    period2Board[5][12] = true;
    period2Board[5][13] = true;
    period2Board[6][12] = true;
    period2Board[7][15] = true;
    period2Board[8][14] = true;
    period2Board[8][15] = true;
}

void prepareStaticBoard() {
    for (int r = 0; r < 12; ++r) {
        for (int c = 0; c < 20; ++c) {
            staticBoard[r][c] = false;
        }
    }

    staticBoard[2][2] = true;
    staticBoard[2][3] = true;
    staticBoard[3][2] = true;
    staticBoard[3][3] = true;

    staticBoard[7][8] = true;
    staticBoard[7][9] = true;
    staticBoard[8][7] = true;
    staticBoard[8][10] = true;
    staticBoard[9][8] = true;
    staticBoard[9][9] = true;

    staticBoard[3][12] = true;
    staticBoard[3][13] = true;
    staticBoard[5][13] = true;
    staticBoard[4][12] = true;
    staticBoard[4][14] = true;

    staticBoard[8][15] = true;
    staticBoard[9][14] = true;
    staticBoard[9][16] = true;
    staticBoard[10][15] = true;
}

bool compareBoard2Grid(int R, int C, bool B[R][C]) {
    if (R != smgHeight() || C != smgWidth())
        return false;
    for (int i = 0; i < R; ++i) {
        for (int j = 0; j < C; ++j) {
            if (smgTest(j,i) != B[i][j])
                return false;
        }
    }
    return true;
}

PICOTEST_SUITE(mainSuite, SANITY_TESTS, INIT_TESTS, COMPOSITE_TESTS)
PICOTEST_CASE(SANITY_TESTS) {
    PICOTEST_VERIFY(!boardInit(0,0,staticBoard), smMsg('A', "test_a-1-1-a", "Zero R/C size accepted for boardInit!"));
    PICOTEST_VERIFY(!boardInit(0,1,staticBoard), smMsg('A', "test_a-1-1-a", "Zero R size accepted for boardInit!"));
    PICOTEST_VERIFY(!boardInit(1,0,staticBoard), smMsg('A', "test_a-1-1-a", "Zero C size accepted for boardInit!"));
    PICOTEST_VERIFY(!boardInit(-1,-1,staticBoard), smMsg('A', "test_a-1-1-b", "Negative R/C size accepted for boardInit!"));
    PICOTEST_VERIFY(!boardInit(-1,1,staticBoard), smMsg('A', "test_a-1-1-b", "Negative R size accepted for boardInit!"));
    PICOTEST_VERIFY(!boardInit(1,-1,staticBoard), smMsg('A', "test_a-1-1-b", "Negative C size accepted for boardInit!"));

    PICOTEST_VERIFY(!calcNextGen(0,0,result12x20), smMsg('A', "test_a-1-1-c", "Zero R/C size accepted for calcNextGen!"));
    PICOTEST_VERIFY(!calcNextGen(0,1,result12x20), smMsg('A', "test_a-1-1-c", "Zero R size accepted for calcNextGen!"));
    PICOTEST_VERIFY(!calcNextGen(1,0,result12x20), smMsg('A', "test_a-1-1-c", "Zero C size accepted for calcNextGen!"));
    PICOTEST_VERIFY(!calcNextGen(-1,-1,result12x20), smMsg('A', "test_a-1-1-d", "Negative R/C size accepted for calcNextGen!"));
    PICOTEST_VERIFY(!calcNextGen(-1,1,result12x20), smMsg('A', "test_a-1-1-d", "Negative R size accepted for calcNextGen!"));
    PICOTEST_VERIFY(!calcNextGen(1,-1,result12x20), smMsg('A', "test_a-1-1-d", "Negative C size accepted for calcNextGen!"));

    PICOTEST_VERIFY(boardInit(4,5,marginTests) && smgWidth() == 5 && smgHeight() == 4, smMsg('A', "test_a-1-1-e", "boardInit for margin board FAILED"));
    PICOTEST_VERIFY(!calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-1-f", "calcNextGen for incompatible grid size DID NOT fail - but it should"));
}
PICOTEST_CASE(INIT_TESTS) {
    prepareStaticBoard();
    preparePeriod2Board();
    prepareAnimatedBoard();
    PICOTEST_VERIFY(boardInit(12,20,staticBoard), smMsg('A', "test_a-1-2-a", "boardInit for static board FAILED"));
    PICOTEST_VERIFY(compareBoard2Grid(12,20,staticBoard), smMsg2('A', "test_a-1-2-b", 20, 12, dd2ds(20, 12, staticBoard), "boardInit static returned bad grid"));
    PICOTEST_VERIFY(boardInit(12,20,period2Board), smMsg('A', "test_a-1-2-a", "boardInit for period2 board FAILED"));
    PICOTEST_VERIFY(compareBoard2Grid(12,20,period2Board), smMsg2('A', "test_a-1-2-b", 20, 12, dd2ds(20, 12, period2Board), "boardInit period2 returned bad grid"));
    PICOTEST_VERIFY(boardInit(12,20,animatedBoard), smMsg('A', "test_a-1-2-a", "boardInit for animated board FAILED"));
    PICOTEST_VERIFY(compareBoard2Grid(12,20,animatedBoard), smMsg2('A', "test_a-1-2-b", 20, 12, dd2ds(20, 12, animatedBoard), "boardInit animated returned bad grid"));
    PICOTEST_VERIFY(boardInit(4,5,marginTests), smMsg('A', "test_a-1-2-a", "boardInit for margin board FAILED"));
    PICOTEST_VERIFY(compareBoard2Grid(4,5,marginTests), smMsg2('A', "test_a-1-2-b", 5, 4, dd2ds(20, 12, marginTests), "boardInit margin returned bad grid see MarginBoard.bmp!%d"));
}

PICOTEST_CASE(COMPOSITE_TESTS) {
    marginTests[0][2] = false;
    marginTests[2][0] = false;
    PICOTEST_VERIFY(boardInit(4,5,marginTests), smMsg('A', "test_a-1-3-a", "boardInit for margin board FAILED"));
    PICOTEST_VERIFY(calcNextGen(4,5,result4x5), smMsg('A', "test_a-1-3-b", "calcNextGen for margin board FAILED"));
    PICOTEST_VERIFY(boardInit(4,5,result4x5), smMsg('A', "test_a-1-3-c", "boardInit for margin board result FAILED"));
    PICOTEST_VERIFY(compareBoards45(marginResult, result4x5), smMsg2('A', "test_a-1-3-d", 5, 4, dd2ds(5, 4, marginResult), "Modified Margin board after 1 generation not the expected one!"));

    prepareStaticBoard();
    PICOTEST_VERIFY(boardInit(12,20,staticBoard), smMsg('A', "test_a-1-3-a", "boardInit for static board FAILED"));
    PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for 1st gen static board FAILED"));
    PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for 1st gen static board result FAILED"));
    PICOTEST_VERIFY(compareBoards(staticBoard, result12x20), smMsg2('A', "test_a-1-3-d", 20, 12, dd2ds(20, 12, staticBoard), "Static board after 1 generation changed!"));

    PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for 2nd gen static board FAILED"));
    PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for 2nd gen static board result FAILED"));
    PICOTEST_VERIFY(compareBoards(staticBoard, result12x20), smMsg2('A', "test_a-1-3-d", 20, 12, dd2ds(20, 12, staticBoard), "Static board after 2 generation changed!"));

    preparePeriod2Board();
    PICOTEST_VERIFY(boardInit(12,20,period2Board), smMsg('A', "test_a-1-3-a", "boardInit for period2 board FAILED"));
//    smGrid2NamedImage("Period2Board0.bmp");
    PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for 1st gen period2 board FAILED"));
    PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for 1st gen period2 board result FAILED"));
    PICOTEST_VERIFY(!compareBoards(period2Board, result12x20), smMsg('A', "test_a-1-3-e", "Period 2 board after 1 generation is UNchanged!"));
    PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for 2st gen period2 board FAILED"));
    PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for 2st gen period2 board result FAILED"));
    PICOTEST_VERIFY(compareBoards(period2Board, result12x20), smMsg2('A', "test_a-1-3-d", 20, 12, dd2ds(20, 12, staticBoard), "Period 2 board after 2 generations is changed!"));

    prepareAnimatedBoard();
    PICOTEST_VERIFY(boardInit(12,20,animatedBoard), smMsg('A', "test_a-1-3-a", "boardInit for animated board FAILED"));
    for (int i = 0; i < 4; ++i) {
        PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for gen %d period2 board FAILED",i+1));
        PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for gen %d period2 board result FAILED",i+1));
    }
    PICOTEST_VERIFY(compareBoards(animatedBoardAfter4, result12x20), smMsg2('A', "test_a-1-3-d", 20, 12, dd2ds(20, 12, animatedBoardAfter4), "Animated board after 4 generations is unexpected!"));
    for (int i = 0; i < 4; ++i) {
        PICOTEST_VERIFY(calcNextGen(12,20,result12x20), smMsg('A', "test_a-1-3-b", "calcNextGen for gen %d period2 board FAILED",i+5));
        PICOTEST_VERIFY(boardInit(12,20,result12x20), smMsg('A', "test_a-1-3-c", "boardInit for gen %d period2 board result FAILED",i+5));
    }
    PICOTEST_VERIFY(compareBoards(animatedBoardAfter8, result12x20), smMsg2('A', "test_a-1-3-d", 20, 12, dd2ds(20, 12, animatedBoardAfter8), "Animated board after 8 generations is unexpected!"));
//    boardInit(12,20,animatedBoardAfter8);
//    smGrid2NamedImage("RESULT-IMAGE.bmp");
}

//PICOTEST_SUITE(mainSuite, RANGE_TESTS, BOUNDARY_TESTS)
//
//PICOTEST_CASE(RANGE_TESTS) {
//    int v5in1_2 = !isInRange(5, 1, 2);
//    PICOTEST_VERIFY(v5in1_2, "isInRange(5,1,2) returns unexpected result!");
//    int v5in1_8 = isInRange(5, 1, 8);
//    PICOTEST_VERIFY(v5in1_8, "isInRange(5,1,8) returns unexpected result!");
//}
//PICOTEST_CASE(BOUNDARY_TESTS) {
//    int v5in1_5 = isInRange(5,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(5,1,5) returns unexpected result!");
//    int v1in1_5 = isInRange(1,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(1,1,5) returns unexpected result!");
//}
//PICOTEST_CASE(aktina_0) {
//}
//PICOTEST_CASE(aktina_PI) {
//}
