// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();
#include <time.h>
#include <errno.h>

#define W 20
#define H 12

void SetupSampleGrid() {
    smGrid(W,H);
    smgOn(1,1);
    smgOn(0,1);
    smgOn(10,1);
    smgOn(1,0);
    smgOn(1,8);
    smgOn(W-2,8);
    smgOn(W-2,H-2);
    smgOn(10,H-2);
    smgOn(10,H-2);
    smgOn(1,H-2);
    smgOn(W-2,1);
    smgOn(3,3);
    smgOn(3,4);
    smgOn(3,5);
    smgOn(4,3);
    smgOn(4,5);
    smgOn(5,3);
    smgOn(5,4);
    smgOn(5,5);
    smgOn(7,3);
    smgOn(9,3);
    smgOn(7,5);
    smgOn(9,5);
    smgOn(11,4);
    smgOn(13,4);
    smgOn(12,3);
    smgOn(12,5);
    smgOn(16,3);
    smgOn(16,4);
    smgOn(16,5);
    smgOn(17,3);
    smgOn(17,4);
    smgOn(17,5);
    smgOn(18,3);
    smgOn(18,4);
    smgOn(18,5);
}

PICOTEST_SUITE(mainSuite, OUT_OF_BOUNDS, ON_BOUNDS, IN_BOUNDS, LARGER_GRID)
PICOTEST_CASE(OUT_OF_BOUNDS) {
    smGrid(W,H);
    PICOTEST_VERIFY(countNeighbors(-1,-1)==-1, smMsg(4, "test_4-2-1-a", "Test at (-100,-100) failed."))
    PICOTEST_VERIFY(countNeighbors(-1,-1)==-1, smMsg(4, "test_4-2-1-a", "Test at (-1,-1) failed."))
    PICOTEST_VERIFY(countNeighbors(-1,5)==-1, smMsg(4, "test_4-2-1-b", "Test at (-1,5) failed."))
    PICOTEST_VERIFY(countNeighbors(5,-1)==-1, smMsg(4, "test_4-2-1-c", "Test at (5,-1) failed."))
    PICOTEST_VERIFY(countNeighbors(W,H)==-1, smMsg(4, "test_4-2-1-d", "Test at (W,H) failed."))
    PICOTEST_VERIFY(countNeighbors(W,10)==-1, smMsg(4, "test_4-2-1-e", "Test at (W,10) failed."))
    PICOTEST_VERIFY(countNeighbors(10,H)==-1, smMsg(4, "test_4-2-1-f", "Test at (10,H) failed."))
    PICOTEST_VERIFY(countNeighbors(-1,H)==-1, smMsg(4, "test_4-2-1-g", "Test at (-1,H) failed."))
    PICOTEST_VERIFY(countNeighbors(W,-1)==-1, smMsg(4, "test_4-2-1-h", "Test at (W,-1) failed."))
    PICOTEST_VERIFY(countNeighbors(100,100)==-1, smMsg(4, "test_4-2-1-i", "Test at (100,100) failed."))
}
PICOTEST_CASE(ON_BOUNDS) {
    SetupSampleGrid();
//    smShowGrid(true);
    PICOTEST_VERIFY(countNeighbors(0,0)==3, smMsg2(4, "test_4-2-2-j", 0,0,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(10,0)==1, smMsg2(4, "test_4-2-2-k", 10,0,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(W-1,0)==1, smMsg2(4, "test_4-2-2-j", W-1,0,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(0,H-1)==1, smMsg2(4, "test_4-2-2-j", 0,H-1,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(10,H-1)==1, smMsg2(4, "test_4-2-2-k", 10,H-1,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(W-1,H-1)==1, smMsg2(4, "test_4-2-2-j", W-1,H-1,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(0,9)==2, smMsg2(4, "test_4-2-2-k", 0,9,NULL, "Test failed, see text grid to help you."))
    PICOTEST_VERIFY(countNeighbors(W-1,9)==2, smMsg2(4, "test_4-2-2-k", W-1,9,NULL, "Test failed, see text grid to help you."))
}
PICOTEST_CASE(IN_BOUNDS) {
    SetupSampleGrid();
    PICOTEST_VERIFY(countNeighbors(4,4) == 8, smMsg2(4, "test_4-2-3-l", 4,4,NULL, "Round test failed, see grid to help you."))
    PICOTEST_VERIFY(countNeighbors(8,4) == 4, smMsg2(4, "test_4-2-3-l", 8,4,NULL, "X test failed, see grid to help you."))
    PICOTEST_VERIFY(countNeighbors(12,4) == 4, smMsg2(4, "test_4-2-3-l", 12,4,NULL, "Cross test failed, see grid to help you."))
    PICOTEST_VERIFY(countNeighbors(17,4) == 8, smMsg2(4, "test_4-2-3-l", 17,4,NULL, "Over #1 test failed, see grid to help you."))
    PICOTEST_VERIFY(countNeighbors(10,1) == 0, smMsg2(4, "test_4-2-3-l", 10,1,NULL, "Over #2 test failed, see grid to help you."))
}
PICOTEST_CASE(LARGER_GRID) {
    smGrid(100,100);
    smgOn(95,95);
    smgOn(97,97);
    PICOTEST_VERIFY(countNeighbors(96,96) == 2, smMsg2(4, "test_4-2-4-m", 96,96,NULL, "Large grid test failed, see grid to help you."))
}