#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();
bool inOrder(double *a1, double *a2, double *a3);

PICOTEST_SUITE(mainSuite, SANITI_TESTS)
PICOTEST_CASE(SANITI_TESTS) {
    double A1, A2, A3;
    bool res;
    A1 = 0; A2 = 0; A3 = 0;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 10; A2 = 5; A3 = 1;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 1; A2 = 5; A3 = 10;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = -1e10; A2 = -1e11; A3 = -1e12;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = -10; A2 = -5; A3 = -1;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 0; A2 = -5; A3 = -10;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 1; A2 = 5; A3 = 2;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 1; A2 = 5; A3 = 1;
    res = inOrder(&A1, &A2, &A3);
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    A1 = 2; A2 = -5; A3 = -2;
    res = inOrder(&A1, &A2, &A3);
    double originalA1 = A1;
    double originalA2 = A2;
    PICOTEST_VERIFY(res && A1 <= A2 && A2 <= A3, smMsg(7, "test_7-1-1-a", "Unexpected order of %lf, %lf, %lf", A1, A2, A3));
    PICOTEST_VERIFY(!inOrder(&A1, &A2, NULL) && A1 == originalA1 && A2 == originalA2, smMsg(7, "test_7-1-1-b", "Unexpected order of %lf, %lf, NULL", A1, A2));
    PICOTEST_VERIFY(!inOrder(&A1, NULL, &A2) && A1 == originalA1 && A2 == originalA2, smMsg(7, "test_7-1-1-b", "Unexpected order of %lf, NULL, %lf", A1, A2));
    PICOTEST_VERIFY(!inOrder(NULL, &A1, &A2) && A1 == originalA1 && A2 == originalA2, smMsg(7, "test_7-1-1-b", "Unexpected order of NULL, %lf, %lf", A1, A2));
    PICOTEST_VERIFY(!inOrder(NULL, NULL, &A1) && A1 == originalA1, smMsg(7, "test_7-1-1-c", "Unexpected order of NULL, NULL, %lf", A1));
    PICOTEST_VERIFY(!inOrder(NULL, &A1, NULL) && A1 == originalA1, smMsg(7, "test_7-1-1-c", "Unexpected order of NULL, %lf, NULL", A1));
    PICOTEST_VERIFY(!inOrder(&A1, NULL, NULL) && A1 == originalA1, smMsg(7, "test_7-1-1-c", "Unexpected order of %lf, NULL, NULL", A1));
    PICOTEST_VERIFY(!inOrder(NULL, NULL, NULL), smMsg(7, "test_7-1-1-d", "Unexpected order of NULL, NULL, NULL"));
}


//PICOTEST_SUITE(mainSuite, RANGE_TESTS, BOUNDARY_TESTS)
//
//PICOTEST_CASE(RANGE_TESTS) {
//    int v5in1_2 = !isInRange(5, 1, 2);
//    PICOTEST_VERIFY(v5in1_2, "isInRange(5,1,2) returns unexpected result!");
//    int v5in1_8 = isInRange(5, 1, 8);
//    PICOTEST_VERIFY(v5in1_8, "isInRange(5,1,8) returns unexpected result!");
//}
//PICOTEST_CASE(BOUNDARY_TESTS) {
//    int v5in1_5 = isInRange(5,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(5,1,5) returns unexpected result!");
//    int v1in1_5 = isInRange(1,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(1,1,5) returns unexpected result!");
//}
//PICOTEST_CASE(aktina_0) {
//}
//PICOTEST_CASE(aktina_PI) {
//}
