#include <stdbool.h>
// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

bool hasSuffix(char text[], char suffix[], bool caseSensitive);

PICOTEST_SUITE(mainSuite, ALL_TESTS)
PICOTEST_CASE(ALL_TESTS) {
    PICOTEST_VERIFY(hasSuffix("This is the one", "one", true), smMsg(6, "test_6-1-1-a", "Failed to detect exact CS single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the one", "one", false), smMsg(6, "test_6-1-1-a", "Failed to detect exact CI single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the stone", "one", true), smMsg(6, "test_6-1-1-a", "Failed to detect exact CS single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the stone", "one", false), smMsg(6, "test_6-1-1-a", "Failed to detect exact CI single word suffix"));

    PICOTEST_VERIFY(!hasSuffix("This is the one", "ONE", true), smMsg(6, "test_6-1-1-b", "Detected CS single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the one", "ONE", false), smMsg(6, "test_6-1-1-c", "Failed to detect CI single word suffix"));

    PICOTEST_VERIFY(!hasSuffix("This is the one", "One", true), smMsg(6, "test_6-1-1-b", "Detected CS first letter different single word suffix"));
    PICOTEST_VERIFY(!hasSuffix("This is the one", "oNE", true), smMsg(6, "test_6-1-1-b", "Detected CS first letter same single word suffix"));

    PICOTEST_VERIFY(hasSuffix("This is the one", "One", false), smMsg(6, "test_6-1-1-b", "Failed to detect CI first letter different single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the one", "oNE", false), smMsg(6, "test_6-1-1-b", "Failed to detect CI first letter same single word suffix"));
    PICOTEST_VERIFY(hasSuffix("This is the one", "ONE", false), smMsg(6, "test_6-1-1-b", "Failed to detect CI single word suffix"));
    PICOTEST_VERIFY(!hasSuffix("ONE", "one", true), smMsg(6, "test_6-1-1-b", "Detected CS single word suffix"));
    PICOTEST_VERIFY(hasSuffix("ONE", "one", false), smMsg(6, "test_6-1-1-a", "Failed to detect CI single word suffix"));
    PICOTEST_VERIFY(hasSuffix("one", "one", true), smMsg(6, "test_6-1-1-a", "Failed to detect CS single word suffix"));
    PICOTEST_VERIFY(!hasSuffix("One to go", "One", true), smMsg(6, "test_6-1-1-d", "Detected CS single word in beginning"));
    PICOTEST_VERIFY(!hasSuffix("One to go", "One", false), smMsg(6, "test_6-1-1-d", "Detected CI single word in beginning"));
    PICOTEST_VERIFY(!hasSuffix("The one to go", "one", true), smMsg(6, "test_6-1-1-e", "Detected CS single word in middle"));
    PICOTEST_VERIFY(!hasSuffix("The one to go", "One", false), smMsg(6, "test_6-1-1-e", "Detected CI single word in middle"));
    PICOTEST_VERIFY(!hasSuffix("This is Sparta", "two", true), smMsg(6, "test_6-1-1-f", "Detected CS inexistent single word"));
    PICOTEST_VERIFY(!hasSuffix("This is Sparta", "two", false), smMsg(6, "test_6-1-1-f", "Detected CI inexistent single word"));
    PICOTEST_VERIFY(hasSuffix("The one to go more than one", "one", true), smMsg(6, "test_6-1-1-g", "Failed to detect CS suffix when the word previously exists"));
    PICOTEST_VERIFY(!hasSuffix("one", "Mascarpone", true), smMsg(6, "test_6-1-1-h", "Detected CS larger suffix than text"));
    PICOTEST_VERIFY(!hasSuffix("One", "Mascarpone", false), smMsg(6, "test_6-1-1-h", "Detected CI larger suffix than text"));
    PICOTEST_VERIFY(!hasSuffix("", "a", false), smMsg(6, "test_6-1-1-i", "Detected non-empty suffix in empty text"));
    PICOTEST_VERIFY(hasSuffix("A test", "", false), smMsg(6, "test_6-1-1-j", "Failed to detect empty suffix to text"));
    PICOTEST_VERIFY(hasSuffix("", "", false), smMsg(6, "test_6-1-1-k", "Failed to detect empty suffix to empty text"));
    printf("\nCI : case insensitive"
           "\nCS : case sensitive\n\n");
}

//PICOTEST_SUITE(mainSuite, RANGE_TESTS, BOUNDARY_TESTS)
//
//PICOTEST_CASE(RANGE_TESTS) {
//    int v5in1_2 = !isInRange(5, 1, 2);
//    PICOTEST_VERIFY(v5in1_2, "isInRange(5,1,2) returns unexpected result!");
//    int v5in1_8 = isInRange(5, 1, 8);
//    PICOTEST_VERIFY(v5in1_8, "isInRange(5,1,8) returns unexpected result!");
//}
//PICOTEST_CASE(BOUNDARY_TESTS) {
//    int v5in1_5 = isInRange(5,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(5,1,5) returns unexpected result!");
//    int v1in1_5 = isInRange(1,1,5);
//    PICOTEST_VERIFY(v5in1_5, "isInRange(1,1,5) returns unexpected result!");
//}
//PICOTEST_CASE(aktina_0) {
//}
//PICOTEST_CASE(aktina_PI) {
//}
