#include <math.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

bool verify(double n, double d, double r) {
    double res = ceiling(n, d);
    double spc = pow(10, -d)/2.0;
    return (r - spc) < res && res < (r + spc);
}

PICOTEST_SUITE(mainSuite,
               ALL_TESTS)
PICOTEST_CASE(ALL_TESTS) {
    PICOTEST_VERIFY(verify(1234.5678, 2, 1234.57), smMsg(2, "test_2-2-1-a", "Lathos stroggyleysh sta 2 dekadika"));
    PICOTEST_VERIFY(!verify(1234.5678, 2, 1234.56), smMsg(2, "test_2-2-1-b", "Lathos stroggyleysh sta 2 dekadika pros ta katw!!"));
    PICOTEST_VERIFY(verify(1.58831, 4, 1.5884), smMsg(2, "test_2-2-1-c", "Lathos stroggyleysh sta 4 dekadika"));
    PICOTEST_VERIFY(verify(0.38, 1, 0.4), smMsg(2, "test_2-2-1-d", "Lathos stroggyleysh sto 1 dekadiko"));
    PICOTEST_VERIFY(verify(1.58831, 0, 2.0), smMsg(2, "test_2-2-1-e", "Lathos stroggyleysh sta 0 dekadika"));
    PICOTEST_VERIFY(verify(-1234.5678, 2, -1234.56), smMsg(2, "test_2-2-1-f", "Lathos stroggyleysh sta 2 dekadika gia arnhtiko arithmo"));
    PICOTEST_VERIFY(verify(1234.5678, -2, 1300.0), smMsg(2, "test_2-2-1-g", "Lathos stroggyleysh sta 2 akairea pshfia"));
}
