#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdarg.h>
#include <float.h>
#include "library.h"

static int smCurrentBufferPos = 0;
static int smCurrentRow = 0;
smString smStringBuffer[SM_MAX_STRING_BUFFER_ROWS] = { NULL };

void smCleanUpBuffer() {
    smCurrentBufferPos = 0;
    for (int i = 0; i < SM_MAX_STRING_BUFFER_ROWS; ++i) {
        if (smStringBuffer[i] != NULL) {
            free( smStringBuffer[i] );
            smStringBuffer[i] = NULL;
        }
    }
    smCurrentRow = 0;
}

int smDoPrint(const char *formatString, ...) {
    va_list args;
    va_start(args, formatString);
    smStringBuffer[smCurrentRow] = smNewString(SM_MAX_STRING_BUFFER);
    vprintf(formatString, args);
    vsprintf(smStringBuffer[smCurrentRow], formatString, args);
    smCurrentRow++;
}

void smShowPrintfs() {
    for (int i = 0; i < smCurrentRow; ++i) {
        fprintf(stdout, "Printf #%d : %s\n", i, smStringBuffer[i]);
    }
}

smString smMsg(int lesson, smString ref, smString msg, ...) {
    va_list args;
    va_start(args, msg);
    smString res = smNewString(4096);
    smString fmsg = smNewString(1024);
    vsprintf(fmsg, msg, args);
    sprintf(res, "%s\nhttps://qna.c-programming.allos.gr/doku.php?id=qna:hw:lsn%02d#%s\n",
                  fmsg,                                                   lesson,   ref);
    return res;
}

smString smPrintfNo(int no) {
    if (no > smCurrentRow) {
        return "PRINT REQUESTED IS AFTER THE MAXIMUM INDEX";
    }
    return smStringBuffer[no-1];
}
int smPrintfRows() {
    return smCurrentRow;
}

int smCharCount(char c, smString string) {
    int counter = 0;
    while (*string != 0) {
        if (*string == c) {
            counter++;
        }
        string++;
    }
    return counter;
}

bool smComparePrintfs(char *first, ...) {
    va_list args;
    va_start(args, first);

    char *line = first;
    int row = 0;

    while (line != NULL) {
        if (strcmp(line, smStringBuffer[row]) != 0) {
            return false;
        }
        line = va_arg(args, char *);
        row++;
    }
    return true;
}

smString smNewString(int numberOfChars) {
    if (numberOfChars < 1) {
        numberOfChars = smEMPTY_STRING_SIZE;
    }
    smString res = malloc(smEMPTY_STRING_SIZE * sizeof(char));
    if (res != NULL) {
        res[0] = '\0';
    }
    return res;
}

smString smReadString(smString message) {
    smString input = smNewString(0);
    if (input) {
        do {
            fprintf(stdout,"%s\n", message);
//            scanf("%s", input);
            gets(input);
        } while (strlen(input) < 1);
    } else {
        fprintf(stderr, "Out of memmory!\n");
    }
    return input;
}

int smReadInt(smString message) {
    int i;
    char line[256];

// NOT scanf, just atoi instead
//    scanf("%d", &r);
    do {
        fprintf(stdout, "%s\n", message);
        gets(line);
    } while ((i = atoi(line)) == 0 && strcmp("0", line) != 0);

    return i;
}

long smReadLong(smString message) {
    long i;

    scanf("%ld", &i);

    return i;
}

double smReadDouble(smString message) {
    double i;

    scanf("%lf", &i);

    return i;
}

/**
 * GRID METHODS
 */

#define _DEFAULT_GRID_W 20
#define _DEFAULT_GRID_H 12
#define _GRID_ON '*'
#define _GRID_OFF ' '

char **_theGrid = NULL;
unsigned char _gW = 0, _gH = 0;

bool deleteGrid() {
    if (!_theGrid) {
        return true;
    }

    for (int k = 0; k < _gH; k++) {
        if (!_theGrid[k]) {
            free(_theGrid[k]);
        }
    }

    free(_theGrid);
    _theGrid = NULL;

    return true;
}

bool smGrid(unsigned char W, unsigned char H) {
    if (W == 0 || H == 0) {
        return false;
    }

    if (_theGrid != NULL) {
        deleteGrid();
    }

    _theGrid = malloc(sizeof(char *) * H);
    if (!_theGrid) {
        return false;
    }
    for (int k = 0; k < H; k++) {
        _theGrid[k] = malloc(sizeof(char) * W);
        if (!_theGrid[k]) {
            deleteGrid();
            return false;
        }
    }

    _gW = W;
    _gH = H;

    for (int r = 0; r < H; ++r) {
        char *row = _theGrid[r];
        for (int c = 0; c < W; ++c) {
            row[c] = _GRID_OFF;
        }
    }

    return true;
}

unsigned char smgWidth() { return _gW; }

unsigned char smgHeight() { return _gH; }

bool smgSet(unsigned char c, unsigned char r, bool on) {
    if (!_theGrid && !smGrid(_DEFAULT_GRID_W, _DEFAULT_GRID_H)) {
        return false;
    }
    if (c >= _gW || r >= _gH) {
        return false;
    }

    _theGrid[r][c] = (on ? _GRID_ON : _GRID_OFF);
    return true;
}

bool smgOn(unsigned char c, unsigned char r) {
    return smgSet(c, r, true);
}

bool smgOff(unsigned char c, unsigned char r) {
    return smgSet(c, r, false);
}

bool smgTest(unsigned char c, unsigned char r) {
    if (!_theGrid && !smGrid(_DEFAULT_GRID_W, _DEFAULT_GRID_H)) {
        return false;
    }
    if ( c >= _gW || r >= _gH ) {
        return false;
    }

    return _theGrid[r][c] == _GRID_ON;
}

bool smgToggle(unsigned char c, unsigned char r) {
    smgSet(c, r, !smgTest(c, r));
}

#ifdef _WIN32
#define cliOpen "start"
#else
#define cliOpen "open"
#endif

#define CORRECTION_VALUE 32
#define GRID_IMG_SCALE 8
#define RULER_OFFSET 10
#define RULER_TICK_FREQ 5
#define GRID_IMG_FILE "GRIDIMAGE.bmp"

/*
bool smGrid2NamedImage(smString filename) {
    if (!_theGrid) {
        return false;
    }

    // create image buffer
    int gridw = _gW * GRID_IMG_SCALE + 1 + RULER_OFFSET;
    int imagew = (gridw/CORRECTION_VALUE + 1)*CORRECTION_VALUE;
    int imageh = _gH * GRID_IMG_SCALE + 1 + RULER_OFFSET;
    rgbData *img = malloc(sizeof(rgbData) * imagew * imageh);

    // clear image
    for (int i = 0; i < imagew * imageh; ++i) {
        img[i].r = 0;
    }

    // draw gridlines
    // verical
    for (int k = 0; k <= _gW; k++) {
    for (int m = 0; m < imageh - (k%RULER_TICK_FREQ?RULER_OFFSET:0); m++) {
        img[RULER_OFFSET+k*GRID_IMG_SCALE+m*imagew].r = 255;
    }}
    // horizontal
    for (int k = 0; k <= _gH; k++) {
    for (int m = (((_gH-k)%RULER_TICK_FREQ)?RULER_OFFSET:0); m < gridw; m++) {
        img[m+k*GRID_IMG_SCALE*imagew].r = 255;
    }}


    // draw the grid
    for (int r = 0; r < _gH; ++r) {
        for (int c = 0; c < _gW; ++c) {

            if (smgTest(c,r)) {
                for (int i = 0; i < GRID_IMG_SCALE; ++i) {
                    for (int j = 0; j < GRID_IMG_SCALE; ++j) {
                        img[c * GRID_IMG_SCALE + j + RULER_OFFSET + (imageh*imagew - (r * GRID_IMG_SCALE + i + RULER_OFFSET + 1) * imagew)].r = 255;
                    }
                }
            }

        }
    }

    saveBitmap(filename, imagew, imageh, imagew, img);
    char buffer[256];
    sprintf(buffer, "%s %s", cliOpen, filename);
    free(img);
    system(buffer);

    return true;
}
bool smGrid2Image() {
    return smGrid2NamedImage(GRID_IMG_FILE);
}
*/

/*
bool smShowGrid(bool showRuler) {
    if (!_theGrid) {
        return false;
    }

    if (showRuler) {
        printf("+");
        for (int i = 0; i < _gW / 10; ++i) {
            printf("----|----%c", i + 1 + '0');
        }
        printf("%*.*s", _gW % 10, _gW % 10, "----|----");
        printf("\n");
    }

    for (int r = 0; r < _gH; ++r) {
        char *row = _theGrid[r];
        if (showRuler) {
            if (r % 10 + 1 == 10) {
                printf("%c", r / 10 + 1 + '0');
            } else {
                printf("%c", "||||-||||"[r % 10]);
            }
        }
        for (int c = 0; c < _gW; ++c) {
            printf("%c", row[c]);
        }
        printf("\n");
    }

    return true;
}
*/
bool smTestGrid(bool **correct) {
    if (!_theGrid) {
        return false;
    }

    for (int r = 0; r < _gH; ++r) {
        char *row = _theGrid[r];
        for (int c = 0; c < _gW; ++c) {
            if ((row[c] == _GRID_ON) != correct[r][c]) {
                return false;
            }
        }
    }

    return true;
}

/*
bool smTestGridTxt(unsigned char rows, ...) {
    if (!_theGrid) {
        return false;
    }
    if (rows != smgHeight()) {
        return false;
    }

    va_list ap;

    va_start(ap, rows);
    for (int i = 0; i < rows; i++) {
        char *row = va_arg(ap, char *);
        unsigned char cols;

        if ((cols = strlen(row)) != smgWidth()) {
            va_end(ap);
            return false;
        }

        for (int j = 0; j < cols; ++j) {
            if ((_theGrid[i][j] == _GRID_ON) != (row[j] == '*')) {
                return false;
            }
        }
    }
    va_end(ap);

    return true;
}*/

#ifndef SM_TEST_EXPR_DBL
/*
 * SM-stuff
 * This is a testing "module" that we use to wrap expressions for early lessons
 */
#define SM_TEST_EXPR_DBL(x, code) bool nTestNo ## x(int i, int j, int k, double a, double b, double c, double correct) { \
double result = ( code );\
bool tst = ( fabs(result-correct) < 1e-10 ); \
if (!tst) {\
    fprintf(stdout, "Failed while evaluating test %d code: %s and got: %lf instead of %lf (where i=%d, j=%d, k=%d, a=%5.3lf, b=%3.2lf, c=%5.3lf)\n", x, #code, result = (code), correct, i,j,k,a,b,c); \
} \
return tst; }
#endif

#ifndef SM_TEST_RET_DBL
/*
 * SM-stuff
 * This is a testing "module" that we use to wrap expressions for early lessons
 */
#define SM_TEST_RET_DBL(x, code) double nTestRetDblNo ## x(int i, int j, int k, double a, double b, double c) { \
double result = -DBL_MAX;\
{\
code                                                                                                   \
}\
return ( result ); }
#endif

#include "../main.c"
#include "../tests/normaltests.c"

int main(int argc, char *argv[]) {
    if (argc > 1 && strcmp(argv[argc - 1], "TeST") == 0) {
        return smTest(argc - 1, argv);
    } else {
        return smMain(argc, argv);
    }
}
