int smTest(int argc, char *argv[]);

#include <stdio.h>
#include "picotest.h"

void printTestCase(const char *name, int nb) {
//    if (nb == 0)
        fprintf(stdout,"%s\n", name);
}


int level = 0;
void indent(int level) {
    while (level--) fprintf(stdout,"  ");
}

/* Test failure logger declaration. */
PicoTestFailureLoggerProc logFailure;
#undef PICOTEST_FAILURE_LOGGER
#define PICOTEST_FAILURE_LOGGER logFailure

/* Test failure logger function. */
void logFailure(const char *file, int line, const char *type, const char *test, const char *msg, va_list args) {
    fprintf(stdout,"\n");
    indent(level);
    fprintf(stdout,"%s FAILED", test);
    /* Optional message. */
    if (msg) {
        fprintf(stdout," : ");
        vprintf(msg, args);
    }
}

/* Hooks */
PicoTestCaseEnterProc logEnter;
PicoTestCaseLeaveProc logLeave;
#undef PICOTEST_CASE_ENTER
#undef PICOTEST_CASE_LEAVE
#define PICOTEST_CASE_ENTER logEnter
#define PICOTEST_CASE_LEAVE logLeave

void logEnter(const char *name) {
    indent(level++);
    fprintf(stdout,"\nTest %s : ", name);
}
void logLeave(const char *name, int fail) {
    level--;
//    if (!fail) {
        indent(level);
        if (fail) {
            fprintf(stdout,"\n%s FAILED!", name);
        } else {
            fprintf(stdout,"Ok");
        }
//        printf("\n%s %s", name, fail?"FAILED":"Ok");
//    }
}

#include "tests-perse.c"

int smTest(int argc, char *argv[]) {
    fprintf(stdout,"TESTING MODE!\n\n");
//    PICOTEST_TRAVERSE(mainSuite, printTestCase);

    mainSuite(NULL);
}
