#include <math.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

PICOTEST_SUITE(mainSuite,
               MULTI_PRINTF,
               SINGLE_PRINTF,
               PERCENT_PRINTF,
               INT_DIV,
               EXPRESSIONS)
PICOTEST_CASE(MULTI_PRINTF) {
    smCleanUpBuffer();
    nTestRetDblNo1(0,0,0,0,0,0);

    bool r_1_1_a = ( smPrintfRows() == 3 );
    PICOTEST_VERIFY(r_1_1_a, smMsg(1, "test_1-1-1-a", "Lathos plhthos printf"));
    bool r_1_1_b = strcmp("Eisagogi sti", smPrintfNo(1)) == 0;
    PICOTEST_VERIFY(r_1_1_b, smMsg(1, "test_1-1-1-b", "Lathos keimeno sthn printf No1"));
    bool r_1_1_c = strcmp("n Pliroforiki & to", smPrintfNo(2)) == 0;
    PICOTEST_VERIFY(r_1_1_c, smMsg(1, "test_1-1-1-c", "Lathos keimeno sthn printf No2"));
    bool r_1_1_d = strcmp("n Programmatismo\n", smPrintfNo(3)) == 0;
    PICOTEST_VERIFY(r_1_1_d, smMsg(1, "test_1-1-1-d", "Lathos keimeno sthn printf No3"));

}
PICOTEST_CASE(SINGLE_PRINTF) {
    smCleanUpBuffer();
    nTestRetDblNo2(0,0,0,0,0,0);

    bool r_1_2_a = ( smPrintfRows() < 1 );
    PICOTEST_VERIFY(!r_1_2_a, smMsg(1, "test_1-1-2-a", "Den exete xrhsimopoihsei kamia printf"));
    bool r_1_2_b = ( smPrintfRows() > 1 );
    PICOTEST_VERIFY(!r_1_2_b, smMsg(1, "test_1-1-2-b", "Lathos plhthos printf"));
    bool r_1_2_c = strcmp("To symvolo / onomazetai \"slash\"\nTo symbolo \\ onomazetai \"backslash\"", smPrintfNo(1)) == 0;
    PICOTEST_VERIFY(r_1_2_c, smMsg(1, "test_1-1-2-c", "Den paragetai to swsto mhnyma."));
    bool r_1_2_d = smCharCount('"', smPrintfNo(1)) == 4;
    PICOTEST_VERIFY(r_1_2_d, smMsg(1, "test_1-1-2-d", "Den paragetai to swsto mhnyma. Yparxei problhma me ta dipla eisagwgika (\")"));
    int bCount = smCharCount('\\', smPrintfNo(1));
    bool r_1_2_e = (bCount < 1);
    PICOTEST_VERIFY(!r_1_2_e, smMsg(1, "test_1-1-2-e", "Den paragetai to swsto mhnyma. Leipei o xarakthras backslash \\"));
    bool r_1_2_f = (bCount > 1);
    PICOTEST_VERIFY(!r_1_2_f, smMsg(1, "test_1-1-2-f", "Den paragetai to swsto mhnyma. O xarakthras backslash \\ emfanizetai %d fores", bCount));
    int lCount = smCharCount('\n', smPrintfNo(1));
    bool r_1_2_g = (lCount < 1);
    PICOTEST_VERIFY(!r_1_2_g, smMsg(1, "test_1-1-2-g", "To mhnyma prepei na einai grammeno se dyo grammes, edw omws einai se mia!"));
    bool r_1_2_h = (lCount > 1);
    PICOTEST_VERIFY(!r_1_2_h, smMsg(1, "test_1-1-2-h", "To mhnyma prepei na einai grammeno se dyo grammes, edw omws einai se perissoteres apo mia!"));
}
PICOTEST_CASE(PERCENT_PRINTF) {
    int is[] = { 50, 0, -1, 100, 88, 200 };

    smCleanUpBuffer();
    for (int j = 0; j < 6; ++j) {
        int i = is[j];

        nTestRetDblNo3(i,0,0,0,0,0);

        smString correct = smNewString(32);
        sprintf(correct, "Success rate: %d%%\n", i);
        smString utility = smNewString(256);
        sprintf(utility, "Den paragetai to swsto mhnyma gia i=%d", i);
        bool r_1_3_a = strcmp(correct, smPrintfNo(j+1)) == 0;
        PICOTEST_VERIFY(r_1_3_a, smMsg(1, "test_1-1-3-a", utility));
        bool r_1_3_b = smCharCount('\n', smPrintfNo(j+1)) == 1;
        PICOTEST_VERIFY(r_1_3_b, smMsg(1, "test_1-1-3-b", "Fainetai na mhn yparxei h alalgh grammhs."));
        bool r_1_3_c = smCharCount('%', smPrintfNo(j+1)) < 1;
        PICOTEST_VERIFY(!r_1_3_c, smMsg(1, "test_1-1-3-c", "Fainetai o xarakthras %% na leipei entelws."));
        bool r_1_3_d = smCharCount('%', smPrintfNo(j+1)) > 1;
        PICOTEST_VERIFY(!r_1_3_d, smMsg(1, "test_1-1-3-d", "Fainetai o xarakthras %% na emfanizetai perissoteres apo mia fores poy apaitoyntai."));
        if (j>0) {
            bool r_1_3_e = strcmp(smPrintfNo(1), smPrintfNo(j + 1)) != 0;
            PICOTEST_VERIFY(r_1_3_e, smMsg(1, "test_1-1-3-e", "To mhnyma den allaxe se sxesh me thn 1h dokimh tou kvdika sas"));
            bool r_1_3_f = strcmp(smPrintfNo(1), smPrintfNo(j + 1)) != 0;
            PICOTEST_VERIFY(r_1_3_f, smMsg(1, "test_1-1-3-f", "To mhnyma den allaxe se sxesh me thn prohgoumenh dokimh tou kvdika sas"));
        }
    }

}
PICOTEST_CASE(INT_DIV) {
    int ws[] = { 60, 90, 120 };
    int hs[] = { 150, 180, 210 };

    double prev = -1.0;
    for (int i = 0; i < 3; ++i) {
        for (int j = 0; j < 3; ++j) {
            int w = ws[i];
            int h = hs[j];

            double R = nTestRetDblNo4(h, w,0,0,0,0);
            double c = ((double)w)/((double)h/100.0)/((double)h/100.0);
            bool isOk = ( fabs(R-c) < 1e-5 );
            // fprintf(stdout, "%d %d => %lf %lf\n", w,h,R,c);
            PICOTEST_VERIFY(R != -DBL_MAX, smMsg(1, "test_1-1-4-a", "Fainetai na mhn exete apothikeysei thn timh sth metablith result"))
            PICOTEST_VERIFY(isOk, smMsg(1, "test_1-1-4-b", "H timi den einai h anamenomenh gia baros %dkg kai ypsos %dcm",w,h));
            PICOTEST_VERIFY(prev != R, smMsg(1, "test_1-1-4-c", "H timi einai idia me ton prohgoymeno ypologismo ths gia diaforetika dedomena!"))
            PICOTEST_VERIFY(R != w, smMsg(1, "test_1-1-4-d", "H timi einai ish me to baros!"))
            bool r_1_1_4_e = fabs(R) > 1.0;
            PICOTEST_VERIFY(r_1_1_4_e, smMsg(1, "test_1-1-4-e", "H timi einai mikroterh apo th monada!"));
        }
    }
    }
PICOTEST_CASE(EXPRESSIONS) {
    /**
     * 1-5 x1
     */
    for (double a = 0; a < 3; ++a) {
        for (double b = 0; b < 3; ++b) {
            for (double c = 0; c < 3; ++c) {
                double C = (5.0/4.0 - a) / ( (b+1)*(c+1) );
                double R = nTestRetDblNo5(0,0,0,a,b,c);
                bool isOk = (fabs(C-R) < 1e-4);
                PICOTEST_VERIFY(isOk, smMsg(1, "test_1-1-5-a", "To apotelesma den einai to anamenomeno gia a=%lf,b=%lf,c=%lf",a,b,c));
            }
        }
    }
    double R1 = nTestRetDblNo5(0,0,0,1.0, 1.0, 1.0);
    PICOTEST_VERIFY(R1!=0, smMsg(1, "test_1-1-5-b", "Fainetai yparxei problhma me akeraia diairesh ston kwdika sas."));
    double R2 = nTestRetDblNo5(0,0,0,2.0, 1.0, 1.0);
    PICOTEST_VERIFY(R1!=R2, smMsg(1, "test_1-1-5-c", "To apotelesma fainetai na mhn e3artatai apo tin timh toy a"));
    double R3 = nTestRetDblNo5(0,0,0,1.0, 2.0, 1.0);
    PICOTEST_VERIFY(R1!=R3, smMsg(1, "test_1-1-5-d", "To apotelesma fainetai na mhn e3artatai apo tin timh toy b"));
    double R4 = nTestRetDblNo5(0,0,0,1.0, 1.0, 2.0);
    PICOTEST_VERIFY(R1!=R4, smMsg(1, "test_1-1-5-e", "To apotelesma fainetai na mhn e3artatai apo tin timh toy c"));

    /**
     * 1-6 x2
     */
    for (double a = 0; a < 3; ++a) {
        for (double b = 0; b < 2.9e8; b += 1e8) {
            for (double c = 0; c < 2.9e8; c += 1e8) {

                double C = (a - (b - 1e8)) * (c + 1e8) / 1e11;
                double R = nTestRetDblNo6(0,0,0,a,b,c);
                PICOTEST_VERIFY(C==R, smMsg(1, "test_1-1-6-a", "To apotelesma den einai to anamenomeno gia a=%lg,b=%lg,c=%lg",a,b,c));

            }
        }
    }
    double Ra1a = nTestRetDblNo6(0,0,0,0, 1e8, 0);
    PICOTEST_VERIFY(fabs(Ra1a)<1e5, smMsg(1, "test_1-1-6-b", "To apotelesma den einai mhdeniko enw 8a eprepe (%lg)", Ra1a));
    double Ra1b = nTestRetDblNo6(0,0,0,0, 0, -1e8);
    PICOTEST_VERIFY(fabs(Ra1b)<1e5, smMsg(1, "test_1-1-6-c", "To apotelesma den einai mhdeniko enw 8a eprepe (%lg)", Ra1b));
    double Ra1 = nTestRetDblNo6(0,0,0,0,0,0);
    double Ra2 = nTestRetDblNo6(0,0,0,2e8, 0, 0);
    PICOTEST_VERIFY(Ra1!=Ra2, smMsg(1, "test_1-1-6-d", "To apotelesma fainetai na mhn e3artatai apo tin timh toy a (%lg vs %lg)",Ra1, Ra2));
    double Ra3 = nTestRetDblNo6(0,0,0,0, 2e8, 0);
    PICOTEST_VERIFY(Ra1!=Ra3, smMsg(1, "test_1-1-6-e", "To apotelesma fainetai na mhn e3artatai apo tin timh toy b (%lg vs %lg)",Ra1, Ra3));
    double Ra4 = nTestRetDblNo6(0,0,0,0, 0, 1e8);
    PICOTEST_VERIFY(Ra1!=Ra4, smMsg(1, "test_1-1-6-f", "To apotelesma fainetai na mhn e3artatai apo tin timh toy c (%lg vs %lg)",Ra1, Ra4));

    /**
     * 1-7 x3
     */
    for (double b = 0; b < 2.9e6; b += 1e6) {
        for (double c = 0; c < 1.9e6; c += 1e6) {
            double C = (1e6 - b) / (1e6 + c);
            double R = nTestRetDblNo7(0,0,0,0,b,c);
            PICOTEST_VERIFY(C==R, smMsg(1, "test_1-1-7-a", "To apotelesma den einai to anamenomeno gia b=%lg,c=%lg",b,c));
        }
    }
    double Rb1a = nTestRetDblNo7(0,0,0,0, 1e6, 0);
    PICOTEST_VERIFY(fabs(Rb1a)<1e5, smMsg(1, "test_1-1-7-b", "To apotelesma den einai mhdeniko enw 8a eprepe (%lg)", Rb1a));
    double Rb1 = nTestRetDblNo7(0,0,0,0,0,0);
    double Rb2 = nTestRetDblNo7(0,0,0,0, 2e6, 0);
    PICOTEST_VERIFY(Rb1!=Rb2, smMsg(1, "test_1-1-7-c", "To apotelesma fainetai na mhn e3artatai apo tin timh toy b (%lg vs %lg)",Rb1, Rb2));
    double Rb3 = nTestRetDblNo7(0,0,0,0, 0, 2e6);
    PICOTEST_VERIFY(Rb1!=Rb3, smMsg(1, "test_1-1-7-d", "To apotelesma fainetai na mhn e3artatai apo tin timh toy c (%lg vs %lg)",Rb1, Rb3));



    /**
     * 1-8 x4
     */
    double as[] = {-1, 10, 50};
    double bs[] = {-1, 20, -50};
    double cs[] = {-1, 30, 50};
    for (int o = 1; o < 3; ++o) {
        for (int p = 1; p < 3; ++p) {
            for (int ai = 0; ai < 3; ++ai) {
                for (int bi = 0; bi < 3; ++bi) {
                    for (int ci = 0; ci < 3; ++ci) {
                        double a = as[ai];
                        double b = bs[bi];
                        double c = cs[ci];
                        int i = o;
                        int j = p;
                        double C = ((a+i)*(b+j)-(a-1)*(c-1))*((b+c)/(a+c))*i/j;
                        double R = nTestRetDblNo8(o,p,0,a,b,c);
                        PICOTEST_VERIFY(C==R, smMsg(1, "test_1-1-8-a", "To apotelesma (%lg) den einai to anamenomeno gia a=%lg,b=%lg,c=%lg kai i=%d,j=%d",R,a,b,c,o,p));
                    }
                }
            }
        }
    }

    double R = nTestRetDblNo8(1,2,0,10,20,30);
    PICOTEST_VERIFY(R!=0, smMsg(1, "test_1-1-8-b", "To apotelesma (%lg) einai mhdeniko enw den 8a eprepe. Prosexte tis akeraies diaireseis.",R));

    double Rc = nTestRetDblNo8(2,2,0,2,2,2);
    double Rc1 = nTestRetDblNo8(5,2,0,2,2,2);
    PICOTEST_VERIFY(Rc!=Rc1, smMsg(1, "test_1-1-8-c", "To apotelesma (%lg) fainetai na mhn e3artatai apo tin timh toy i",Rc1));
    double Rc2 = nTestRetDblNo8(2,5,0,2,2,2);
    PICOTEST_VERIFY(Rc!=Rc2, smMsg(1, "test_1-1-8-d", "To apotelesma (%lg) fainetai na mhn e3artatai apo tin timh toy j",Rc2));
    double Rc3 = nTestRetDblNo8(2,2,0,5,2,2);
    PICOTEST_VERIFY(Rc!=Rc3, smMsg(1, "test_1-1-8-e", "To apotelesma (%lg) fainetai na mhn e3artatai apo tin timh toy a",Rc3));
    double Rc4 = nTestRetDblNo8(2,2,0,2,5,2);
    PICOTEST_VERIFY(Rc!=Rc4, smMsg(1, "test_1-1-8-f", "To apotelesma (%lg) fainetai na mhn e3artatai apo tin timh toy b",Rc4));
    double Rc5 = nTestRetDblNo8(2,2,0,2,2,5);
    PICOTEST_VERIFY(Rc!=Rc5, smMsg(1, "test_1-1-8-g", "To apotelesma (%lg) fainetai na mhn e3artatai apo tin timh toy c",Rc5));

}