#ifndef SMLIB_LIBRARY_H
#define SMLIB_LIBRARY_H

#ifndef smEMPTY_STRING_SIZE
#define smEMPTY_STRING_SIZE 1024
#endif

#ifndef SM_MAX_STRING_BUFFER
#define SM_MAX_STRING_BUFFER 4096
#endif

#ifndef SM_MAX_STRING_BUFFER_ROWS
#define SM_MAX_STRING_BUFFER_ROWS 1024
#endif

#ifndef printf
#define printf smDoPrint
#endif

typedef char * smString;

/**
 * Αντικατάσταση της main για τις ανάγκες του μαθήματος
 */
int smMain(int argc, char *argv[]);
int smTest(int argc, char *argv[]);

smString smNewString(int numberOfChars);

smString smReadString(smString message);

void smCleanUpBuffer();
int smDoPrint(const char *formatString, ...);
int smPrintfRows();
void smShowPrintfs();
smString smMsg(int lesson, smString ref, smString msg, ...);
smString smPrintfNo(int no);
int smCharCount(char c, smString string);
bool smComparePrintfs(char *first, ...);

int smReadInt(smString message);
long smReadLong(smString message);
double smReadDouble(smString message);

bool smGrid(unsigned char W, unsigned char H);

bool smgSet(unsigned char c, unsigned char r, bool on);
bool smgOn(unsigned char c, unsigned char r);
bool smgOff(unsigned char c, unsigned char r);
bool smgTest(unsigned char c, unsigned char r);
bool smgToggle(unsigned char c, unsigned char r);

bool smShowGrid(bool showRuler);
bool smTestGrid(bool **correct);
bool smTestGridTxt(unsigned char rows, ...);
#endif //SMLIB_LIBRARY_H