#include <math.h>

// AVAILABLE CHECK TYPES
//    PICOTEST_ASSERT(check1);
//    PICOTEST_VERIFY(0, "BETA");
//    PICOTEST_ABORT();

PICOTEST_SUITE(mainSuite, SANITY_TESTS, VALUE_TESTS)

PICOTEST_CASE(SANITY_TESTS) {
    PICOTEST_VERIFY(getDigit(99, 1)   == -1, smMsg(3, "test_3-2-1-b", "getDigit(99, 1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(111, 1)  ==  1, smMsg(3, "test_3-2-1-a", "getDigit(111, 1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(999, 1)  ==  9, smMsg(3, "test_3-2-1-a", "getDigit(999, 1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(1000, 1) == -1, smMsg(3, "test_3-2-1-b", "getDigit(1000, 1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(123, 0)  == -2, smMsg(3, "test_3-2-1-d", "getDigit(123, 0) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(100, -1) == -2, smMsg(3, "test_3-2-1-d", "getDigit(100, -1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(777, 1)  ==  7, smMsg(3, "test_3-2-1-a", "getDigit(777, 1) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(888, 3)  ==  8, smMsg(3, "test_3-2-1-a", "getDigit(888, 3) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(950, 4)  == -2, smMsg(3, "test_3-2-1-c", "getDigit(950, 4) returns unexpected result!"));
    PICOTEST_VERIFY(getDigit(95, 4)   == -2, smMsg(3, "test_3-2-1-d", "getDigit(95, 4) returns unexpected result!"));
}
PICOTEST_CASE(VALUE_TESTS) {
    PICOTEST_VERIFY(getDigit(123, 1) == 1,   smMsg(3, "test_3-2-1-e", "getDigit(123, 1) returns unexpected result for leftmost digit!"));
    PICOTEST_VERIFY(getDigit(123, 2) == 2,   smMsg(3, "test_3-2-1-f", "getDigit(123, 2) returns unexpected result for middle digit!"));
    PICOTEST_VERIFY(getDigit(123, 3) == 3,   smMsg(3, "test_3-2-1-g", "getDigit(123, 3) returns unexpected result for rightmost digit!"));
    PICOTEST_VERIFY(getDigit(123, 3) != 1,   smMsg(3, "test_3-2-1-h", "getDigit(123, 3) returns unexpected result, the leftmost digit instead of the rightmost!!"));
    PICOTEST_VERIFY(getDigit(123, 3) != 2,   smMsg(3, "test_3-2-1-i", "getDigit(123, 3) returns unexpected result, the middle digit instead of the rightmost!!"));
    PICOTEST_VERIFY(getDigit(987, 1) == 9,   smMsg(3, "test_3-2-1-e", "getDigit(987, 1) returns unexpected result for leftmost digit!"));
    PICOTEST_VERIFY(getDigit(987, 2) == 8,   smMsg(3, "test_3-2-1-f", "getDigit(987, 2) returns unexpected result for middle digit!"));
    PICOTEST_VERIFY(getDigit(987, 3) == 7,   smMsg(3, "test_3-2-1-g", "getDigit(987, 3) returns unexpected result for rightmost digit!"));
    PICOTEST_VERIFY(getDigit(987, 3) != 9,   smMsg(3, "test_3-2-1-h", "getDigit(987, 1) returns unexpected result, the rightmost digit instead of the leftmost!"));
    PICOTEST_VERIFY(getDigit(987, 3) != 8,   smMsg(3, "test_3-2-1-i", "getDigit(987, 1) returns unexpected result, the middle digit instead of the leftmost!"));
    PICOTEST_VERIFY(getDigit(578, 1) == 5,   smMsg(3, "test_3-2-1-e", "getDigit(987, 1) returns unexpected result for leftmost digit!"));
    PICOTEST_VERIFY(getDigit(578, 1) != 7,   smMsg(3, "test_3-2-1-j", "getDigit(987, 1) returns unexpected result for leftmost digit!"));
    PICOTEST_VERIFY(getDigit(578, 1) != 8,   smMsg(3, "test_3-2-1-k", "getDigit(987, 1) returns unexpected result for leftmost digit!"));
    PICOTEST_VERIFY(getDigit(902, 2) == 0,   smMsg(3, "test_3-2-1-f", "getDigit(902, 2) returns unexpected result for middle digit!"));
}
