#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>

/*
 * Η δομή αναπαριστά έναν πραγματικό αριθμό με άπειρα ψηφία
 * ως κείμενο. Το κείμενο περιέχει μόνο αριθμητικά ψηφία και
 * όχι υποδιαστολή. Επίσης η δομή κρατά το πλήθος των ψηφίων
 * του ακέραιου και του δεκαδικού μέρους. Προφανώς σε κανονική
 * κατάσταση θα πρέπει το μήκος του string που παριστάνει τον
 * αριθμό να είναι ίσο με το άθροισμα των ψηφίων του ακέραιου
 * και του δεκαδικού μέρους του αριθμού.
 */
typedef struct _infy_float {
    char *digits;
    int intDigits;
    int decDigits;
} InfyFloat;

/*
 * Ο βασικός constructor ενός InfyFloat.
 * Του δίνεται το πλήθος των ψηφίων του
 * ακέραιου και του δεκαδικού μέρους.
 *
 * Δεν χρειάζεται να έχει συγκεκριμένα
 * ψηφία αλλά σίγουρα θα πρέπει να έχει
 * το σωστό μήκος.
 */
InfyFloat *ifCreate(int iDig, int dDig) {
    // Ελέγχουμε τα δεδομένα
    // Μήπως ζητήθηκε αρνητικό πλήθος ψηφίων;
    // Κάτι τέτοιο δεν θα είχε νόημα αφού μιλάμε για πλήθος
    if (iDig < 0 || dDig < 0) {
        // Πάντα ως ένδειξη λάθους (δεδομένου ότι η συνάρτηση
        // επιστρέφει pointer) επιστρέφω την τιμή NULL
        return NULL;
    }

    // Δεσμεύουμε μνήμη για τη δομή
    InfyFloat *result = (InfyFloat *)malloc(sizeof (InfyFloat));
    // Πάντα ελέγχουμε το αποτέλεσμα της malloc
    if (result == NULL) {
        return NULL;
    }

    // Δεσμεύουμε την απαιτούμενη μνήμη για το πλήθος των ψηφίων
    // που ζητήθηκε
    result->digits = (char *)malloc((iDig+dDig+1)*sizeof(char));
    // Πάντα ελέγχουμε το αποτέλεσμα της malloc
    if (result->digits == NULL) {
        // εάν ήταν ανεπιτυχής η δέσμευση αποδεσμεύουμε τη
        // μνήμη που είχαμε δεσμεύσει και μετά επιστρέφουμε NULL
        free(result);
        return NULL;
    }
    // Για κάθε στοιχείο του πίνακα των χαρακτήρων
    for (int i = 0; i < iDig+dDig; ++i) {
        // Βάζω τον χαρακτήρα '0', με το σκεπτικό ότι αφού
        // δεν μου ζητούν κάτι συγκεκριμένο και το '0' είναι
        // μια χαρά
        result->digits[i] = '0';
    }
    // Βάζω τον τερματικό χαρακτήρα με κωδικό 0 στο τέλος
    // του πίνακα. Δηλαδή στη θέση όσο είναι το μήκος του
    // πίνακα (όχι του string) - 1. Το μήκος του πίνακα
    // είναι όσο του string (iDig+dDig) + 1 για τον τερματικό
    // μηδενικό χαρακτήρα. Άρα...
    result->digits[iDig+dDig /* +1-1 */] = 0;
    // Κρατάμε και το πλήθος των ψηφίων του ακέραιου και
    // δεκαδικού μέρους αντίστοιχα
    result->intDigits = iDig;
    result->decDigits = dDig;

    // Επιστρέφουμε τον δείκτη στη δομή που δεσμεύσαμε
    // και ετοιμάσαμε
    return result;
}

/*
 * Συνάρτηση που επικυρώνει τη "σωστή" κατάσταση μιας
 * δομής InfyFloat. Επιστρέφει ως boolean δηλαδή true
 * ή false το κατά πόσο είναι valid, δηλαδή έγκυρη η
 * κατάστασή της.
 */
bool ifValidate(InfyFloat *iFlo) {
    // εάν δόθηκε NULL δείκτης
    if (iFlo == NULL) {
        // τότε δεν είναι έγκυρη δομή InfyFloat
        return false;
    }

    // εάν το πλήθος των ψηφίων είναι αρνητικό
    if (iFlo->intDigits < 0 || iFlo->decDigits < 0) {
        // τότε δεν είναι έγκυρη δομή InfyFloat
        return false;
    }

    // εάν ο δείκτης στην αναπαράσταση του αριθμού
    // ως κειμένου είναι NULL
    if (iFlo->digits == NULL) {
        // τότε δεν είναι έγκυρη δομή InfyFloat
        return false;
    }

    // εάν το άθροισμα του πλήθους των ψηφίων του
    // ακέραιου μέρους και του δεκαδικού, δεν είναι
    // ίσο με το μήκος του string (όχι το μήκος του
    // πίνακα)
    if (iFlo->intDigits + iFlo->decDigits != strlen(iFlo->digits)) {
        // τότε δεν είναι έγκυρη δομή InfyFloat
        return false;
    }

    // για κάθε ψηφίου της αναπαράστασης (που είναι σε μορφή κειμένου)
    // από τη θέση 0 μέχρι και την (iFlo->intDigits + iFlo->decDigits)
    // που όπως ελέγξαμε παραπάνω ταυτίζεται με το μήκος του κειμένου
    for (int i = 0; i < iFlo->intDigits + iFlo->decDigits; ++i) {
//        Εναλλακτικός τρόπος ελέγχου εάν το ψηφίου στη θέση i το
//        ψηφίο αυτό δεν είναι αριθμητικός χαρακτήρας.
//        if (iFlo->digits[i] < '0' || '9' < iFlo->digits[i])
        // έλεγχος εάν το ψηφίο ΔΕΝ είναι αριθμητικό
        if (!isdigit(iFlo->digits[i])) {
            // τότε δεν είναι έγκυρη δομή InfyFloat
            return false;
        }
    }

    // εάν όλοι οι έλεγχοι μέχρι εδώ πέρασαν τότε
    // η δομή έχει έγκυρο περιεχόμενο
    return true;
}

int main() {
    printf("Hello, World!\n");
    return 0;
}
