#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*
 * Βοηθητική συνάρτηση που επιστρέφει την ΑΞΙΑ (0-9)
 * του ψηφίου του Χ το οποίο βρίσκεται στη θέση dig,
 * η οποία αντιστοιχεί στο ψηφίο 0 για μονάδες, 1 για
 * δεκάδες, 2 για εκατοντάδες, κ.ο.κ.
 */
int getDigitValue(char *X, int dig) {
    // εάν δεν δίνεται αριθμός τότε όλα τα ψηφία τα επιστρέφουμε ως 0
    if (X == NULL) {
        return 0;
    }
    // το μήκος του Χ ως κείμενο (τα ψηφία που έχει ο αριθμός)
    int L = strlen(X);
    // εάν το ζητούμενο ψηφίο είναι εκτός των ορίων του δεδομένου
    // αριθμού τότε ουσιαστικά είναι μηδενικό. Ακόμα και για αρνητικό
    // δείκτη, δηλαδή για ψηφία που θα αντιστοιχούσαν στο δεκαδικό
    // μέρος του αριθμού (που βέβαια δεν έχει αφού είναι ακέραιος)
    if (dig < 0 || L-1 < dig) {
        // τότε όλα είναι μηδενικά
        return 0;
    }
    // σε κάθε άλλη περίπτωση (δηλαδή είμαστε μέσα στα
    // ψηφία του Χ) επιστρέφουμε το ψηφίο της κατάλληλης
    // θέσης ( L-1 είναι ο τελευταίος,δεξιότερα χαρακτήρας
    // του αριθμού ). Δηλαδή οι μονάδες. Από αυτόν πάμε
    // προς τα αριστερά (=αφαιρούμε) το πλήθος των θέσεων
    // που δίνεται.
    //
    // Σημειώστε ότι θα μπορούσαμε να κάνουμε έλεγχο για το
    // κατά πόσο είναι όντως αριθμητικός ο χαρακτήρας και εάν
    // δεν ήταν θα έπρεπε να επιστρέφεται κάποια τιμή ως ένδειξη
    // λάθους πχ -1, αλλά θα έπρεπε να το προβλέπει και αυτό ο
    // κώδικας στο σημείο που καλείται η getDigitValue
    return X[L-1-dig] - '0';
}

/*
 * Η ζητούμενη συνάρτηση που αθροίζει δύο ακέραιους
 * αριθμούς με οποιοδήποτε πλήθος ψηφίων (ίσως και
 * χιλιάδες ψηφία), αποθηκευμένους ως κείμενο με
 * χαρακτήρες που είναι όλοι αριθμητικά ψηφία.
 *
 * Επιστρέφει το αποτέλεσμα με την ίδια μορφή.
 * Εάν κάποιο δεδομένο δοθεί ως NULL, τότε να
 * θεωρείται ως το 0 εκφρασμένο με μορφή κειμένου.
 */
char *sumOfIntegers(char *A, char *B) {
    // εάν δεν δοθεί αριθμός τότε θεωρούμε
    // ότι είναι ο "0". Θα μπορούσαμε να
    // κάνουμε το ίδιο και όταν δοθεί ο
    // αριθμός "" αλλά δεν χρειάζεται γιατί
    // αυτή την περίπτωση τη διαχειρίζεται
    // σωστά ο υπόλοιπος κώδικας
    if (A == NULL /*|| strlen(A) == 0*/) {
        A = "0";// = [48, 0]  0xa7f027    vs '0' == 48 poy einai la8os!!
    }
    // ομοίως και για το Β
    if (B == NULL) { B = "0"; }

    // τώρα που δεν είναι NULL τα A και Β βρίσκουμε
    // τα μήκη τους (ως κείμενα)
    int LA = strlen(A);
    int LB = strlen(B);

    // υπολογίζουμε το μήκος του πίνακα του αθροίσματος
    // που είναι όσο το μεγαλύτερο από τα LA και LB και
    // σε αυτό προσθέτουμε έναν χαρακτήρα για τον τερματικό
    // κωδικό 0 και άλλο ένα για το παραπάνω ψηφίο που
    // μπορεί να προκύψει στην πρόσθεση λόγω του κρατούμενου
    int LSum = ((LA > LB) ? LA : LB) + 1 + 1;
    // δεσμεύουμε την απαιτούμενη μνήμη για το άθροισμα
    char *Sum = (char *)malloc(LSum * sizeof(char));
    // εάν δεν υπάρχει διαθέσιμη
    if (Sum == NULL) {
        // επιστρέφουμε το NULL ως ένδειξη λάθους
        return NULL;
    }
    // βάζουμε το τερματικό 0 (κωδικός 0, όχι ο χαρακτήρας
    // '0') στο τέλος του αποτελέσματος
    Sum[LSum - 1] = 0;
    // ορίζουμε το κρατούμενο που αρχικά είναι 0 προφανώς
    int carry = 0;
    // ορίζουμε μία μεταβλητή που κρατά το ψηφίο το οποίο
    // αθροίζουμε κάθε φορά. Ξεκινάμε με το 0 που αντιστοιχεί
    // στις μονάδες
    int d = 0;

    // για κάθε χαρακτήρα του αποτελέσματος (ξεκινώντας από τον
    // δεξιότερο μέχρι τον αριστερότερο - δηλαδή τον πρόσθετο που
    // μπορεί να προκύψει)
    for (int i = LSum - 2; i >= 0 ; --i, d++) {
        // υπολογίζουμε το άθροισμα των αξιών των αντίστοιχων
        // ψηφίων των Α και Β συν το κρατούμενο. Ο αριθμός που
        // προκύπτει μπορεί να είναι από 0 (=0+0+0) μέχρι 19 (=9+9+1)
        int digSum = getDigitValue(A, d) + getDigitValue(B, d) + carry;
        // άρα το ψηφίο παίρνει το υπόλοιπο της διαίρεσης του
        // αθροίσματος με το 10 (συν τον κωδικό του '0' ώστε
        // να περιέχει το Sum[i] τον χαρακτήρα που πρέπει)
        Sum[i] = (digSum % 10) + '0';
        // το κρατούμενο είναι το πηλίκο της ΑΚΕΡΑΙΑΣ διαίρεσης
        // του digSum με το 10 (θυμίζουμε ότι αφού και οι δύο
        // ποσότητες είναι int, τότε και το αποτέλεσμα είναι
        // int, άρα πχ για 8/10 προκύπτει 0 και για 11/10 προκύπτει
        // 1)
        carry = digSum / 10;
        // προχωρούμε στην επόμενη επανάληψη/επόμενο ψηφίο οπότε
        // αλλάζει και ο δείκτης i (--i) αλλά και το ζητούμενο
        // ψηφίο d (d++). Αυτά όμως γράφονται πάνω στο for
    }


    //// Θα μπορούσε να ελεγχθεί μετά το τέλος της πρόσθεσης ότι το
    /// τελευταίο κρατούμενο που προκύπτει είναι 0, όμως δεν ζητείται
    /// από την εκφώνηση κάτι τέτοιο
    //if (carry != 0) {
    //    free(Sum);
    //    return NULL;
    //}

    // τέλος επιστρέφουμε το άθροισμα των Α και Β με τη μορφή κειμένου
    // όπως υπολογίστηκε
    return Sum;
}

int main() {
//    printf("%d\n", getDigitValue(NULL,6));
    printf("%c\n", '4');
    printf("%d\n", '4');
    printf("%s\n", "1924837");
    printf("%s\n", sumOfIntegers(
            "12435",
              "234"
            ));
    return 0;
}
