#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char **splitAt( char separator, char *text, int *N );

int main() {
    // η μεταβλητή που θα κρατήσει το πλήθος των "φράσεων"
    int K = -1;
    // καλείται η συνάρτηση για separator , και για κείμενο
    // "Ab,cd, ef,, gh ,i"
    char **phrases = splitAt(',', "Ab,cd, ef,, gh ,i", &K);

    // εάν δεν βρεθούν φράσεις
    if (phrases == NULL) {
        // τυπώνουμε ένα μήνυμα με την έκλπηξή μας
        printf("ERROR!!");
        // και τερματίζουμε τον κώδικα με μη-μηδενικό
        // κωδικό
        return -1;
    } else {
        // εάν όλα πήγαν καλά για κάθε "φράσγ" που βρέθηκε,
        for (int i = 0; i < K; ++i) {
            // εκτυπώνουμε την ίδια τη "φράση"
            printf("%s\n", phrases[i]);
        }
    }

    // τερματισμός του προγράμματος με μηδενικό κωδικό σφάλματος
    return 0;
}

/*
 * Η συνάρτηση splitAt χωρίζει ένα δεδομένο κείμενο (το text) σε
 * μικρότερα κείμενα ("φράσεις") βάσει ενός χαρακτήρα διαχωρισμού
 * (separator) π.χ. στο κείμενο "one,two,three" με διαχωριστικό
 * το ',' θα επιστρέφει έναν πίνακα ["one","two","three"]
 *
 * Προσοχή! Όταν λέμε "φράση" εννοούμε το οποιοδήποτε κείμενα,
 * πριν, μετά και ανάμεσα στους χαρακτήρες διαχωρισμού (separator)
 *
 * Το πλήθος των "φράσεων" που βρήκε, δηλαδή το μήκος του πίνακα
 * ο οποίος επιστράφηκε δίνεται μέσω της παραμέτρου N, η οποία γι'αυτό
 * το λόγο δίνεται ως pointer.
 *
 * Εάν δεν είναι δυνατόν να ολοκληρωθεί επιτυχώς η εκτέλεση της
 * συνάρτησης θα πρέπει να επιστρέφει NULL.
 */
char **splitAt( char separator, char *text, int *N ) {
    // αρχικά γίνεται έλεγχος των δεδομένων. Εάν οι pointers είναι
    // NULL, τότε δεν μπορούμε να προχωρήσουμε. Ομοίως και εάν ο
    // διαχωριστικός χαρακτήρας είναι ο κωδικός 0.
    if (text == NULL || N == NULL || separator == 0) {
        return NULL;
    }

    // υπολογίζω το μήκος του δεδομένου κειμένου
    int length = strlen(text);


    // ζητάω μνήμη για να αποθηκεύσω ένα αντίγραφο του κειμένου, δηλαδή
    // όσους χαρακτήρες έχει (length) και έναν επιπλέον (+1) για το
    // τερματικό μηδέν στο τέλος του κειμένου.
    //
    // Το αντίγραφο δημιουργείται για δύο λόγους. Πρώτος και βασικότερος
    // είναι ότι δεν είναι σωστό να μεταβάλουμε το δεδομένο κείμενο και
    // δεύτερος είναι ότι κάποιες φορές μπορεί να υπάρχει τεχνικός
    // περιορισμός στο να το μεταβάλουμε (πχ μνήμη που δόθηκε στην splitAt
    // μπορεί να προορίζεται μόνο για ανάγνωση)
    char *copy = (char *)malloc(length+1);
    // Εάν δεν υπάρχει διαθέσιμη μνήμη
    if (copy == NULL) {
        // τότε η συνάρτηση μας αποτυγχάνει και δεν υπάρχει κάτι που
        // χρειάζεται αποδέσμευση (πχ μνήμη ή αρχείο)
        return NULL;
    }

    // αντιγράφεται το αρχικό κείμενο στον χώρο που κρατήσαμε για
    // το αντίγραφο
    strcpy(copy, text);

    // υποθέτω αρχικό πλήθος φράσεων 1 (αφού τόσες "φράσεις") θα
    // υπάρχουν ακόμα και όταν δεν υπάρχει καμία εμφάνιση του
    // χαρακτήρα separator
    int phraseCount = 1;

    // Α ΤΡΟΠΟΣ Αντικατάστασης των separator με 0 και καταμέτρησή τους
    // για κάθε γράμμα του κειμένου
    for (int i = 0; i < length; ++i) {
        // εάν ο χαρακτήρας του αντιγράφου στη θέση i είναι ο
        // διαχωριστικός (separator)
        if (copy[i] == separator) {
            // τότε βάζω τον τερματικό κωδικό 0 για την προηγούμενη φράση
            copy[i] = 0;
            // δηλαδή υπάρχει μία ακόμα φράση (που ξεκινά
            // μετά από αυτόν τον χαρακτήρα)
            phraseCount++;
        }
    }

//    // Β ΤΡΟΠΟΣ Αντικατάστασης των separator με 0 και καταμέτρησή τους
//    // με τη χρήση pointers
//    char *help = copy;
//    while (*help != 0) {
//        if (*help == separator) {
//            *help = 0;
//            phraseCount++;
//        }
//        help++;
//    }

    // βάσει του αριθμού των φράσεων δεσμεύουμε μνήμη για τους
    // pointers σε κάθε φράση
    char **phrases = (char **)malloc(phraseCount * sizeof(char *));
    // εάν δεν υπάρχει αρκετή μνήμη
    if (phrases == NULL) {
        // αποδεσμεύουμε αυτή που είχαμε δεσμεύσει
        free(copy);
        // και επιστρέφουμε NULL ως ένδειξη του προβλήματος
        return NULL;
    }

    // η μεταβλητή αυτή δείχνει ποιά είναι η "τρέχουσα" φράση
    // αυτή δηλαδή που έχουμε βρει πιο "πρόσφατα"
    int currentPhrase = 0;
    // σε αυτή τη θέση βάζουμε και τον δείκτη για την αρχή της
    // λέξης. Η πρώτη λέξη είναι πάντα στην αρχή του κειμένου
    phrases[0] = copy;
    // νοηματικά ορθότερο, αλλά ισοδύναμο στην περίπτωσή μας
    // θα ήταν: phrases[currentPhrase] αντί για phrases[0]
    // ενώ εάν θέλουμε να δούμε την αναλογία με τον κώδικα που
    // ακολουθεί, αντί για σκέτο copy θα γράφαμε το ισοδύναμο,
    // αλλά καθόλου λακωνικό: &copy[0];

    // κατόπιν για κάθε χαρακτήρα
    for(int i=0; i<length;++i) {
        // εάν ο χαρακτήρας είναι ο 0, σημαίνει ότι εκεί τελειώνει η
        // τρέχουσα φράση (επειδή σε αυτό το σημείο υπήρχε ένας
        // χαρακτήρας διαχωρισμού)
        if (copy[i] == 0) {
            // αυξάνουμε κατά ένα την τρέχουσα φράση (μπαίνουμε στην επόμενη)
            currentPhrase++;
            // και η αρχή της είναι στην επόμενη θέση χαρακτήρα (i+1) ενώ
            // με το & παίρνουμε τον pointer γι'αυτή τη θέση.
            phrases[currentPhrase] = &copy[i+1];
            // εάν η τρέχουσα φράση που βρήκαμε είναι η τελευταία
            // (και επειδη ως δείκτης πίνακα πάει μέχρι την προηγούμενη
            // τιμή από το πλήθος των στοιχείων, χρειάζεται και το -1)
            if (currentPhrase == phraseCount-1) {
                // τότε σταματούν οι επαναλήψεις - αυτό το κάνουμε για
                // να μην εξετάζει ο κώδικας άσκοπα το υπόλοιπο κείμενο
                // το οποίο αποτελεί την τελευταία φράση
                break;
            }
        }
    }

    // θέτουμε στην μεταβλητή που επιστρέφουμε το πλήθος των "φράσεων" που
    // βρέθηκαν κατά την παραπάνω διαδικασία
    *N = phraseCount;
    // και επιστρέφουμε τον πίνακα με τους pointers στις "φράσεις"
    return phrases;
}