#include <stdio.h>
#include <stdlib.h>

/*
 * Ορίζεται η δομή ως τύπος ArrayPlus
 * που περιγράφει έναν πίνακα (pointer)
 * μαζί με το μήκος του
 */
typedef struct _arrPlus {
    double *arr;
    int length;
} ArrayPlus;

/*
 * Ο destructor του απελευθερώνει τη μνήμη του
 * πίνακα και της δομής
 */
void deleteArrayPlus(ArrayPlus *arrayPlus) {
    // αν δεν δόθηκε pointer, αλλά NULL
    if (arrayPlus == NULL) {
        // τερματίζει η συνάρτηση - δεν έχει να κάνει κάτι
        return;
    }

    // εάν όντως το μέλος arr δείχνει κάπου στη μνήμη
    // και δεν είναι NULL...
    if (arrayPlus->arr != NULL) {
        // τότε πρέπει να το απελευθερώσουμε
        // πριν από την ίδια τη δομή
        free(arrayPlus->arr);
    }

    // την δομή την απελευθερώνουμε έτσι και
    // αλλιώς αφού στην ελέγξαμε ως μη-NULL
    // στην αρχή της συνάρτησης
    free(arrayPlus);
}

/*
 * Constructor για πίνακα αρχικού μεγέθους
 * size. Προφανώς ο πίνακας δεν δημιουργείται
 * "άδειος" αφού κάτι τέτοιο δεν έχει νόημα,
 * αλλά δημιουργείται με σκοπό να τον γεμίσει
 * όποιος τον ζήτησε αμέσως μετά τη δημιουργία
 * του, οπότε και δεν μας ενδιαφέρει το αρχικό
 * του περιεχόμενο.
 */
ArrayPlus *createArrayPlus(int size) {
    // έλεγχος δεδομένων - αν μας ζήτησαν πίνακα με λιγότερα από 1 στοιχεία
    if (size < 1) {
        // επιστρέφουμε NULL ως ένδειξη λάθους
        return NULL;
    }

    // δεσμεύουμε μνήμη για τη δομή
    ArrayPlus *result = (ArrayPlus *)malloc( sizeof(ArrayPlus) );
    // εάν δεν υπάρχει η απαραίτητη μνήμη
    if (result == NULL) {
        // τερματίζουμε τη συνάρτηση με ένδειξη
        // λάθους και δεν υπάρχει κάτι που είχαμε
        // δεσμεύσει πριν ώστε να το αποδεσμεύσουμε
        return NULL;
    }

    // στη δομή που μόλις δεσμεύσαμε δίνουμε τιμή
    // στο μέλος που δείχνει το επιθυμητό μήκος
    // του πίνακα
    result->length = size;
    // και ζητάμε μνήμη όση χρειάζεται ο πίνακας (όσα στοιχεία
    // έχει * το μέγεθος του κάθε στοιχείου)
    result->arr = (double *)malloc( size * sizeof(double) );
    // εάν δεν βρεθεί η ζητούμενη ποσότητα μνήμης
    if (result->arr == NULL) {
        // αποδεσμεύουμε ό,τι έχουμε δεσμεύσει μέχρι τώρα
        // είτε άμεσα, οπότε αποδεσμεύουμε απλά τη δομή
        //     free(result);
        // είτε έμμεσα καλώντας τον destructor, εφόσον αυτός
        // είναι "προσεκτικά" ορισμένος
        deleteArrayPlus(result);
        // και επιστρέφουμε NULL ως ένδειξη λάθους
        return NULL;
    }

    // αλλιώς - όλα πήγαν καλά - επιστρέφουμε
    // τον pointer στη δομή
    return result;
}

/*
 * Η συνάρτηση αυτή πρέπει να ενώνει - τον ένα μετά
 * τον άλλο - δύο πίνακες τύπου ArrayPlus σε έναν νέο
 * ArrayPlus πίνακα
 */
ArrayPlus *joinArrayPlus(ArrayPlus *A, ArrayPlus *B) {
    // εάν δεν δίνονται και οι δύο πίνακες
    if (A == NULL || B == NULL) {
        // επιτρέφεται NULL ως ένδειξη λάθους
        return NULL;
    }

    // Υποθέτω/Δίνεται από την εκφώνηση, ότι εφόσον δεν
    // είναι NULL τα A και B, τότε ΔΕΝ χρειάζονται έλεγχο
    // για τις τιμές των πεδίων τους (πχ αρνητικό length
    // ή NULL το arr). Δεχόμαστε ότι είναι οκ.

    // Ζητάω τη δημιουργία ενός πίνακα με το κατάλληλο
    // μέγεθος ώστε να χωρά τα στοιχεία του Α και του Β
    // μαζί
    ArrayPlus *result = createArrayPlus(A->length + B->length);
    // εάν δεν υπάρχει διαθέσιμη μνήμη
    if (result == NULL) {
        // τερματίζω τον κώδικα
        return NULL;
    }

    // Α ΤΡΟΠΟΣ - Αντιγραφής των στοιχείων των Α και Β στον νέο ArrayPlus
    //            Αυτός είναι ο πιο ξεκάθαρος
    // for (int i = 0; i < A->length; ++i) {
    //     result->arr[i] =A->arr[i];
    // }
    // for (int i = 0; i < B->length; ++i) {
    //     result->arr[i+A->length] = B->arr[i];
    // }

    // Β ΤΡΟΠΟΣ - Αντιγραφής των στοιχείων των Α και Β στον νέο ArrayPlus
    //            Αυτός είναι πιο αποτελεσματικός
    // int i;
    // for (i = 0; i < A->length; ++i) {
    //     result->arr[i] =A->arr[i];
    // }
    // for (int j = 0; j < B->length; ++j, ++i) {
    //     result->arr[i] = B->arr[j];
    // }

    // Γ ΤΡΟΠΟΣ - Ενδιάμεση λύση
    //            Κατά βάση είναι ίδιος με τον Β τρόπο, αλλά
    //            είναι πιο ξεκάθαρο το γιατί/πως το i ξεκινά
    //            από την τιμή A->length, όπως συνέβαινε και
    //            στον Β τρόπο
    for (int i = 0; i < A->length; ++i) {
        result->arr[i] =A->arr[i];
    }
    for (int i = A->length, j=0; j < B->length; ++i, ++j) {
        result->arr[i] = B->arr[j];
    }

    // τέλος επιστρέφεται ο πίνακας με τα ενωμένα στοιχεία
    return result;
}

int main() {
    printf("Hello, World!\n");
    return 0;
}
