#include <stdio.h>
#include <stdbool.h>

#define EMPTY 0
#define playerX 1
#define playerO 2

int playersTurn(int board[3][3]);
bool tripletExists(int board[3][3], int player);
bool canPlay(int board[3][3], int r, int c, int player);
bool playAt(int board[3][3], int r, int c);

int main() {
    int board[3][3] = {
        { playerX,   EMPTY, playerO },
        {   EMPTY, playerX, playerO },
        {   EMPTY,   EMPTY,   EMPTY }
    };

    printf("%d\n", playersTurn(board));
    if (tripletExists(board, playerX)) {
        printf("O paikths X ekane triliza!\n");
    }
    if (tripletExists(board, playerO)) {
        printf("O paikths O ekane triliza!\n");
    }
    return 0;
}

int playersTurn(int board[3][3]) {
    int countX = 0;
    int countO = 0;

    for (int y = 0; y < 3; ++y) {
        for (int x = 0; x < 3; ++x) {
            int cellContent = board[y][x];

            if (cellContent == playerX) {
                countX++;
            } else if (cellContent == playerO) {
                countO++;
            } else if (cellContent != EMPTY) {
                return -1;
            }
        }
    }

    if (countX + countO == 9) {
        return -1;
    } else if (countX == countO) {
        return playerX;
    } else if (countX == countO + 1) {
        return playerO;
    } else {
        return -1;
    }
}

bool tripletExists(int board[3][3], int player) {
    bool isTriplet = true;

    // Kyria diagonios
    for (int i = 0; i < 3; ++i) {
        if (board[i][i] != player) {
            isTriplet = false;
            break;
        }
    }

    if (isTriplet) {
        return true;
    }

    // Apenanti diagonios
    isTriplet = true;
    for (int i = 0; i < 3; ++i) {
        if (board[i][2-i] != player) {
            isTriplet = false;
            break;
        }
    }
    if (isTriplet) {
        return true;
    }

    // Sthles
    for (int j = 0; j < 3; ++j) {
        isTriplet = true;
        for (int i = 0; i < 3; ++i) {
            if (board[i][j] != player) {
                isTriplet = false;
                break;
            }
        }
        if (isTriplet) {
            return true;
        }
    }

    // Grammes
    for (int j = 0; j < 3; ++j) {
        isTriplet = true;
        for (int i = 0; i < 3; ++i) {
            if (board[j][i] != player) {
                isTriplet = false;
                break;
            }
        }
        if (isTriplet) {
            return true;
        }
    }

    return false;
}

bool canPlay(int board[3][3], int r, int c, int player) {
    if (board[r][c] != EMPTY) {
        return false;
    }

    int turn = playersTurn(board);
    bool winX = tripletExists(board, playerX);
    bool winO = tripletExists(board, playerO);

    if (turn == player && !winX && !winO) {
        return true;
    } else {
        return false;
    }

    // B tropos
//    return turn == player && !winX && !winO;
}
bool playAt(int board[3][3], int r, int c) {
    int turn = playersTurn(board);
    if (turn == -1) {
        return false;
    }

    if (canPlay(board, r, c, turn)) {
        board[r][c] = turn;
        return true;
    } else {
        return false;
    }
}
