#include <stdio.h>
#include <stdbool.h>

#define smString char *

#define KNOWN_NYD_DAY_OF_WEEK 5
#define KNOWN_YEAR 2021


bool isLeapYear(int year) {
    if (year % 400 == 0) {
        return true;
    } else if (year % 100 == 0) {
        return false;
    } else if (year % 4 == 0) {
        return true;
    } else {
        return false;
    }
}

smString monthName(int month) {
    // ...
    return "blah";
}
smString dayName(int day) {
    switch (day) {
        case 0:
            return "Su";
        case 1:
            return "Mo";
        case 2:
            return "Tu";
        case 3:
            return "We";
        case 4:
            return "Th";
        case 5:
            return "Fr";
        case 6:
            return "Sa";
        default:
            return "No such day!";
    }
}
int monthDays(int month, int year) {
    switch (month) {
        case 1:
        case 3:
        case 5:
        case 7:
        case 8:
        case 10:
        case 12:
            return 31;
        case 4:
        case 6:
        case 9:
        case 11:
            return 30;
        case 2:
            if (isLeapYear(year)) {
                return 29;
            } else {
                return 28;
            }
        default:
            return -1;
    }
}

int daysSince2021NYD(int day, int month, int year) {
    if (year < KNOWN_YEAR) {
        return -1;
    }
    if (month < 1 || month > 12) {
        return -2;
    }
    if (day < 1 || day > monthDays(month, year)) {
        return -3;
    }

    int result = 0;
    // imeres etwn
    for (int y = KNOWN_YEAR; y < year; ++y) {
        if (isLeapYear(year)) {
            result += 366;
        } else {
            result += 365;
        }
    }
    // imeres mhnwn
    for (int m = 1; m < month; ++m) {
        result += monthDays(month, year);
    }
    // imeres mhna
    result += day;

    return result;
}

void printEngDate(int day, int month, int year) {
    int daysSince = daysSince2021NYD(day, month, year);
    if (daysSince < 0) {
        printf("Oops!\n");
        return;
    }
    int daysInLastWeek = daysSince % 7;
    int daysFromKnownDay = daysInLastWeek + KNOWN_NYD_DAY_OF_WEEK - 1;
    int weekDay = daysFromKnownDay % 7;
    printf("%s , %d %s %d", dayName(weekDay), day, monthName(month), year );
}

int main() {
    printEngDate(31,3,2022);
    return 0;
}
